/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

import de.unijena.bioinf.ChemistryBase.algorithm.Scored;
import de.unijena.bioinf.ChemistryBase.fp.ClassyfireProperty;
import de.unijena.bioinf.ChemistryBase.fp.FPIter;
import de.unijena.bioinf.ChemistryBase.fp.FingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.MaskedFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.MolecularProperty;
import de.unijena.bioinf.fingerid.CSVExporter;
import de.unijena.bioinf.fingerid.CanopusResult;
import de.unijena.bioinf.fingerid.FingerIdResult;
import de.unijena.bioinf.sirius.IdentificationResult;
import de.unijena.bioinf.sirius.core.ApplicationCore;
import de.unijena.bioinf.sirius.projectspace.DirectoryWriter;
import de.unijena.bioinf.sirius.projectspace.ExperimentResult;
import gnu.trove.map.hash.TIntFloatHashMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class FingerIdResultWriter
extends DirectoryWriter {
    protected List<Scored<String>> topHits = new ArrayList<Scored<String>>();
    protected TIntFloatHashMap canopusSummary = new TIntFloatHashMap(2048, 0.75f, -1, -1.0f);
    protected FingerprintVersion canopusVersion = null;
    protected FingerprintVersion csiVersion = null;

    public FingerIdResultWriter(DirectoryWriter.WritingEnvironment w) {
        super(w, ApplicationCore.VERSION_STRING);
    }

    protected void startWritingIdentificationResults(ExperimentResult er, List<IdentificationResult> results) throws IOException {
        super.startWritingIdentificationResults(er, results);
        if (this.isAllowed("fingerid.candidates") && this.hasFingerId(results)) {
            this.W.enterDirectory("fingerprints");
            for (IdentificationResult result : results) {
                FingerIdResult f = (FingerIdResult)result.getAnnotationOrNull(FingerIdResult.class);
                if (f == null) continue;
                this.writeFingerprint(result, f);
            }
            this.W.leaveDirectory();
            this.W.enterDirectory("csi_fingerid");
            ArrayList<FingerIdResult> frs = new ArrayList<FingerIdResult>();
            for (IdentificationResult result : results) {
                FingerIdResult f = (FingerIdResult)result.getAnnotationOrNull(FingerIdResult.class);
                if (f == null) continue;
                frs.add(f);
                this.writeFingerIdResult(result, f);
            }
            this.W.leaveDirectory();
            if (this.hasCanopus(results)) {
                this.W.enterDirectory("canopus");
                for (IdentificationResult result : results) {
                    CanopusResult r = (CanopusResult)result.getAnnotationOrNull(CanopusResult.class);
                    if (r == null) continue;
                    this.writeCanopus(result, r);
                }
                this.W.leaveDirectory();
            }
            this.writeFingerIdResults(er, results, frs);
        }
    }

    private void writeFingerprint(IdentificationResult result, FingerIdResult f) throws IOException {
        if (this.csiVersion == null) {
            this.csiVersion = f.predictedFingerprint.getFingerprintVersion();
        }
        this.write(FingerIdResultWriter.makeFileName((IdentificationResult)result) + ".fpt", w -> {
            for (FPIter fp : f.predictedFingerprint) {
                w.write(String.format(Locale.US, "%.3f\n", fp.getProbability()));
            }
        });
    }

    private void writeCanopus(IdentificationResult result, CanopusResult r) throws IOException {
        if (this.canopusVersion == null) {
            this.canopusVersion = r.canopusFingerprint.getFingerprintVersion();
        }
        this.write(FingerIdResultWriter.makeFileName((IdentificationResult)result) + ".fpt", w -> {
            for (FPIter iter : r.getCanopusFingerprint()) {
                w.write(String.format(Locale.US, "%.2f\n", iter.getProbability()));
            }
        });
    }

    private boolean hasFingerId(List<IdentificationResult> results) {
        for (IdentificationResult r : results) {
            if (r.getAnnotationOrNull(FingerIdResult.class) == null) continue;
            return true;
        }
        return false;
    }

    private boolean hasCanopus(List<IdentificationResult> results) {
        for (IdentificationResult r : results) {
            if (r.getAnnotationOrNull(CanopusResult.class) == null) continue;
            return true;
        }
        return false;
    }

    protected void endWriting() {
        super.endWriting();
        try {
            this.writeSummary();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeSummary() throws IOException {
        if (this.isAllowed("fingerid.candidates") && this.topHits.size() > 0) {
            this.write("summary_csi_fingerid.csv", new DirectoryWriter.Do(){

                public void run(Writer w) throws IOException {
                    Collections.sort(FingerIdResultWriter.this.topHits, Scored.desc());
                    w.write("source\texperimentName\tconfidence\tinchikey2D\tinchi\tmolecularFormula\trank\tscore\tname\tsmiles\txlogp\tpubchemids\tlinks\n");
                    for (Scored<String> s : FingerIdResultWriter.this.topHits) {
                        w.write((String)s.getCandidate());
                    }
                }
            });
        }
        this.writeFingerprintIndex("fingerprints.csv", this.csiVersion);
        this.writeCanopusIndex("canopus.csv", this.canopusVersion);
    }

    private void writeFingerprintIndex(String filename, FingerprintVersion version) throws IOException {
        if (version == null) {
            return;
        }
        this.write(filename, w -> {
            int[] indizes;
            if (version instanceof MaskedFingerprintVersion) {
                indizes = ((MaskedFingerprintVersion)version).allowedIndizes();
            } else {
                indizes = new int[version.size()];
                for (int i = 0; i < indizes.length; ++i) {
                    indizes[i] = i;
                }
            }
            w.write("relativeIndex\tabsoluteIndex\tdescription\n");
            int k = 0;
            for (int index : indizes) {
                MolecularProperty prop = version.getMolecularProperty(index);
                w.write(String.valueOf(k++));
                w.write(9);
                w.write(String.valueOf(index));
                w.write(9);
                w.write(prop.getDescription());
                w.write(10);
            }
        });
    }

    private void writeCanopusIndex(String filename, FingerprintVersion version) throws IOException {
        if (version == null) {
            return;
        }
        this.write(filename, w -> {
            int[] indizes;
            if (version instanceof MaskedFingerprintVersion) {
                indizes = ((MaskedFingerprintVersion)version).allowedIndizes();
            } else {
                indizes = new int[version.size()];
                for (int i = 0; i < indizes.length; ++i) {
                    indizes[i] = i;
                }
            }
            w.write("relativeIndex\tabsoluteIndex\tname\tchemontId\tdescription\n");
            int k = 0;
            for (int index : indizes) {
                ClassyfireProperty prop = (ClassyfireProperty)version.getMolecularProperty(index);
                w.write(String.valueOf(k++));
                w.write(9);
                w.write(String.valueOf(index));
                w.write(9);
                w.write(prop.getName());
                w.write(9);
                w.write(prop.getChemontIdentifier());
                w.write(9);
                w.write(prop.getDescription().replaceAll("[\t\n]", " "));
                w.write(10);
            }
        });
    }

    private void writeFingerIdResults(ExperimentResult er, List<IdentificationResult> results, List<FingerIdResult> frs) throws IOException {
        StringWriter w = new StringWriter(128);
        new CSVExporter().exportFingerIdResults(w, frs);
        final String topHit = w.toString();
        double confidence = frs.size() > 0 ? frs.get(0).getConfidence() : 0.0;
        String[] lines = topHit.split("\n", 3);
        if (lines.length >= 2) {
            this.topHits.add((Scored<String>)new Scored((Object)(er.getExperimentSource() + "\t" + er.getExperimentName() + "\t" + confidence + "\t" + lines[1] + "\n"), confidence));
        }
        this.write("summary_csi_fingerid.csv", new DirectoryWriter.Do(){

            public void run(Writer w) throws IOException {
                w.write(topHit);
            }
        });
    }

    private void writeFingerIdResult(IdentificationResult result, final FingerIdResult f) throws IOException {
        this.write(FingerIdResultWriter.makeFileName((IdentificationResult)result) + ".csv", new DirectoryWriter.Do(){

            public void run(Writer w) throws IOException {
                new CSVExporter().exportFingerIdResults(w, Arrays.asList(f));
            }
        });
    }
}

