/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.db;

import de.unijena.bioinf.chemdb.DatasourceService;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CustomDataSourceService {
    private static final Set<DataSourceChangeListener> listeners = new LinkedHashSet<DataSourceChangeListener>();
    private static final int lastEnumBit;
    private static final BitSet bits;
    public static final Map<String, Source> SOURCE_MAP;

    public static boolean removeCustomSource(String name) {
        Source s = CustomDataSourceService.getSourceFromName(name);
        if (s == null) {
            return true;
        }
        if (s.isCustomSource()) {
            s = SOURCE_MAP.remove(name);
            bits.andNot(BitSet.valueOf(new long[]{s.flag()}));
            CustomDataSourceService.notifyListeners(Collections.singleton(s.name()));
            return true;
        }
        return false;
    }

    public static int size() {
        return SOURCE_MAP.size();
    }

    public static Iterable<Source> sources() {
        return SOURCE_MAP.values();
    }

    public static Source addCustomSourceIfAbsent(String name) {
        Source s = CustomDataSourceService.getSourceFromName(name);
        if (s == null) {
            int bitIndex = bits.nextClearBit(lastEnumBit);
            bits.set(bitIndex);
            long flag = 1 << bitIndex;
            CustomSource r = new CustomSource(flag, name);
            SOURCE_MAP.put(name, r);
            CustomDataSourceService.notifyListeners(Collections.singleton(r.name()));
            return r;
        }
        return null;
    }

    public static Set<String> getDataSourcesFromBitFlags(long flags) {
        HashSet<String> set = new HashSet<String>();
        return CustomDataSourceService.getDataSourcesFromBitFlags(set, flags);
    }

    public static Set<String> getDataSourcesFromBitFlags(Set<String> set, long flags) {
        for (Source s : SOURCE_MAP.values()) {
            if ((flags & s.flag()) != s.flag()) continue;
            set.add(s.name());
        }
        return set;
    }

    public static Source getSourceFromName(String name) {
        return SOURCE_MAP.get(name);
    }

    public static void notifyListeners(Collection<String> changed) {
        for (DataSourceChangeListener listener : listeners) {
            listener.fireDataSourceChanged(changed);
        }
    }

    public static boolean removeListener(DataSourceChangeListener listener) {
        return listeners.remove(listener);
    }

    public static boolean addListener(DataSourceChangeListener listener) {
        return listeners.add(listener);
    }

    static {
        SOURCE_MAP = new LinkedHashMap<String, Source>(DatasourceService.Sources.values().length * 5);
        long b = 0L;
        for (DatasourceService.Sources s : DatasourceService.Sources.values()) {
            SOURCE_MAP.put(s.name, new EnumSource(s));
            b |= s.flag;
        }
        bits = BitSet.valueOf(new long[]{b});
        lastEnumBit = bits.cardinality();
    }

    public static interface DataSourceChangeListener
    extends EventListener {
        public void fireDataSourceChanged(Collection<String> var1);
    }

    static class CustomSource
    implements Source {
        public final long flag;
        public final long searchFlag;
        public final String name;

        public CustomSource(long flag, long searchFlag, String name) {
            this.flag = flag;
            this.searchFlag = searchFlag;
            this.name = name;
        }

        public CustomSource(long flag, String name) {
            this(flag, flag, name);
        }

        @Override
        public long flag() {
            return this.flag;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String sqlQuery() {
            return null;
        }

        @Override
        public long searchFlag() {
            return this.searchFlag;
        }

        @Override
        public String URI() {
            return null;
        }

        @Override
        public boolean isCustomSource() {
            return true;
        }

        @Override
        public String getLink(String id) {
            return null;
        }
    }

    static class EnumSource
    implements Source {
        public final DatasourceService.Sources source;

        public EnumSource(DatasourceService.Sources source) {
            this.source = source;
        }

        @Override
        public long flag() {
            return this.source.flag;
        }

        @Override
        public String name() {
            return this.source.name;
        }

        @Override
        public String sqlQuery() {
            return this.source.sqlQuery;
        }

        @Override
        public long searchFlag() {
            return this.source.searchFlag;
        }

        @Override
        public String URI() {
            return this.source.URI;
        }

        @Override
        public boolean isCustomSource() {
            return false;
        }

        @Override
        public String getLink(String id) {
            return this.source.getLink(id);
        }
    }

    public static interface Source {
        public long flag();

        public String name();

        public String sqlQuery();

        public long searchFlag();

        public String URI();

        public boolean isCustomSource();

        public String getLink(String var1);
    }
}

