/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.db;

import com.google.common.collect.ArrayListMultimap;
import com.google.gson.stream.JsonWriter;
import de.unijena.bioinf.ChemistryBase.chem.InChI;
import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.fp.ArrayFingerprint;
import de.unijena.bioinf.ChemistryBase.fp.BooleanFingerprint;
import de.unijena.bioinf.ChemistryBase.fp.CdkFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.Fingerprint;
import de.unijena.bioinf.ChemistryBase.fp.FingerprintVersion;
import de.unijena.bioinf.chemdb.BioFilter;
import de.unijena.bioinf.chemdb.CompoundCandidate;
import de.unijena.bioinf.chemdb.DBLink;
import de.unijena.bioinf.chemdb.DatabaseException;
import de.unijena.bioinf.chemdb.DatasourceService;
import de.unijena.bioinf.chemdb.FingerprintCandidate;
import de.unijena.bioinf.chemdb.RESTDatabase;
import de.unijena.bioinf.fingerid.Compound;
import de.unijena.bioinf.fingerid.Fingerprinter;
import de.unijena.bioinf.fingerid.db.CustomDataSourceService;
import de.unijena.bioinf.fingerid.db.SearchableDatabase;
import de.unijena.bioinf.fingerid.net.WebAPI;
import de.unijena.bioinf.fingerid.storage.ConfigStorage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.inchi.InChIGenerator;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.qsar.descriptors.molecular.XLogPDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.smiles.SmilesParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDatabase
implements SearchableDatabase {
    protected static Logger logger = LoggerFactory.getLogger(CustomDatabase.class);
    protected String name;
    protected File path;
    protected long numberOfCompounds;
    protected long numberOfFormulas;
    protected long megabytes;
    protected boolean deriveFromPubchem;
    protected boolean deriveFromBioDb;
    protected CdkFingerprintVersion version;
    protected int databaseVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDatabase() {
        CustomDatabase customDatabase = this;
        synchronized (customDatabase) {
            if (this.path.exists()) {
                for (File f : this.path.listFiles()) {
                    f.delete();
                }
                this.path.delete();
                CustomDataSourceService.removeCustomSource(this.name);
            }
        }
    }

    public static List<CustomDatabase> customDatabases(boolean up2date) {
        ArrayList<CustomDatabase> databases = new ArrayList<CustomDatabase>();
        File root = ConfigStorage.CONFIG_STORAGE.getDatabaseDirectory();
        File custom = new File(root, "custom");
        if (!custom.exists()) {
            return databases;
        }
        for (File subDir : custom.listFiles()) {
            if (!subDir.isDirectory()) continue;
            CustomDatabase db = new CustomDatabase(subDir.getName(), subDir);
            try {
                db.readSettings();
                if (up2date && db.needsUpgrade()) continue;
                databases.add(db);
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return databases;
    }

    public static CustomDatabase createNewdatabase(String name, File path, CdkFingerprintVersion version) {
        CustomDatabase db = new CustomDatabase(name, path);
        db.databaseVersion = 1;
        db.version = version;
        return db;
    }

    public CustomDatabase(String name, File path) {
        this.name = name;
        this.path = path;
        CustomDataSourceService.addCustomSourceIfAbsent(this.name);
    }

    public void buildDatabase(List<File> files, ImporterListener listener) throws IOException, CDKException {
        Importer importer = this.getImporter();
        HashMap dict = new HashMap(100);
        InChIGeneratorFactory icf = InChIGeneratorFactory.getInstance();
        importer.init();
        importer.addListener(listener);
        for (File f : files) {
            importer.importFrom(f);
        }
        importer.flushBuffer();
    }

    public boolean needsUpgrade() {
        return this.databaseVersion != 1;
    }

    public void inheritMetadata(File otherDb) throws IOException {
    }

    public boolean isDeriveFromPubchem() {
        return this.deriveFromPubchem;
    }

    public void setDeriveFromPubchem(boolean deriveFromPubchem) {
        this.deriveFromPubchem = deriveFromPubchem;
    }

    public boolean isDeriveFromBioDb() {
        return this.deriveFromBioDb;
    }

    public void setDeriveFromBioDb(boolean deriveFromBioDb) {
        this.deriveFromBioDb = deriveFromBioDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSettings() throws IOException {
        CustomDatabase customDatabase = this;
        synchronized (customDatabase) {
            if (this.settingsFile().exists()) {
                this.deriveFromPubchem = false;
                this.deriveFromBioDb = false;
                try (FileReader r = new FileReader(this.settingsFile());){
                    JsonNumber nc;
                    JsonArray fpAry;
                    JsonObject o = Json.createReader((Reader)r).readObject();
                    JsonArray ary = o.getJsonArray("inheritance");
                    if (ary != null) {
                        for (JsonValue v : ary) {
                            if (!(v instanceof JsonString)) continue;
                            String s = ((JsonString)v).getString();
                            if (s.equals(DatasourceService.Sources.PUBCHEM.name)) {
                                this.deriveFromPubchem = true;
                            }
                            if (!s.equals(DatasourceService.Sources.BIO.name)) continue;
                            this.deriveFromBioDb = true;
                        }
                    }
                    if ((fpAry = o.getJsonArray("fingerprintVersion")) == null) {
                        this.version = CdkFingerprintVersion.getDefault();
                    } else {
                        ArrayList<CdkFingerprintVersion.USED_FINGERPRINTS> usedFingerprints = new ArrayList<CdkFingerprintVersion.USED_FINGERPRINTS>();
                        for (JsonValue v : fpAry) {
                            if (!(v instanceof JsonString)) continue;
                            try {
                                usedFingerprints.add(CdkFingerprintVersion.USED_FINGERPRINTS.valueOf((String)((JsonString)v).getString().toUpperCase()));
                            }
                            catch (IllegalArgumentException e) {
                                throw new RuntimeException("Unknown fingerprint type '" + ((JsonString)v).getString() + "'");
                            }
                        }
                        this.version = new CdkFingerprintVersion(usedFingerprints.toArray(new CdkFingerprintVersion.USED_FINGERPRINTS[usedFingerprints.size()]));
                    }
                    JsonNumber num = o.getJsonNumber("schemaVersion");
                    this.databaseVersion = num == null ? 0 : num.intValue();
                    JsonObject stats = o.getJsonObject("statistics");
                    if (stats != null && (nc = stats.getJsonNumber("compounds")) != null) {
                        this.numberOfCompounds = nc.intValue();
                    }
                }
                long filesize = 0L;
                int ncompounds = 0;
                if (this.getDatabasePath().exists()) {
                    for (File f : this.getDatabasePath().listFiles()) {
                        filesize += Files.size(f.toPath());
                        ++ncompounds;
                    }
                    --ncompounds;
                }
                this.megabytes = Math.round((double)filesize / 1024.0 / 1024.0);
                this.numberOfFormulas = ncompounds;
            }
        }
    }

    public Importer getImporter() {
        return new Importer(this, this.version);
    }

    protected File settingsFile() {
        return new File(this.path, "settings.json");
    }

    public void setFingerprintVersion(CdkFingerprintVersion version) {
        this.version = version;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean searchInPubchem() {
        return this.deriveFromPubchem;
    }

    @Override
    public boolean searchInBio() {
        return this.deriveFromBioDb || this.deriveFromPubchem;
    }

    @Override
    public boolean isCustomDb() {
        return true;
    }

    @Override
    public File getDatabasePath() {
        return this.path;
    }

    public String toString() {
        return this.name;
    }

    public static class Importer {
        private String[] commonNameProps = new String[0];
        private String[] dbIDProps = new String[0];
        final CustomDatabase database;
        File currentPath;
        List<ImporterListener> listeners = new ArrayList<ImporterListener>();
        private final List<FingerprintCandidate> buffer;
        private List<IAtomContainer> moleculeBuffer;
        protected Fingerprinter fingerprinter;
        protected InChIGeneratorFactory inChIGeneratorFactory;
        protected SmilesGenerator smilesGen;
        protected SmilesParser smilesParser;
        protected CdkFingerprintVersion fingerprintVersion;

        protected Importer(CustomDatabase database, CdkFingerprintVersion version) {
            this.database = database;
            this.fingerprintVersion = version;
            this.buffer = new ArrayList<FingerprintCandidate>();
            this.moleculeBuffer = new ArrayList<IAtomContainer>();
            this.currentPath = database.path;
            if (this.currentPath == null) {
                throw new NullPointerException();
            }
            try {
                this.inChIGeneratorFactory = InChIGeneratorFactory.getInstance();
                this.smilesGen = SmilesGenerator.generic().aromatic();
                this.fingerprinter = Fingerprinter.getFor((FingerprintVersion)version);
                this.smilesParser = new SmilesParser(SilentChemObjectBuilder.getInstance());
                this.smilesParser.kekulise(true);
            }
            catch (CDKException e) {
                throw new RuntimeException(e);
            }
        }

        public void setCommonNameProps(String[] commonNameProps) {
            this.commonNameProps = commonNameProps;
        }

        public void setDbIDProps(String[] dbIDProps) {
            this.dbIDProps = dbIDProps;
        }

        public void addListener(ImporterListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ImporterListener listener) {
            this.listeners.remove(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public void collect(ImporterListener listener) {
            for (File f : this.currentPath.listFiles()) {
                if (!f.getName().endsWith("json.gz")) continue;
                Importer importer = this;
                synchronized (importer) {
                    try (JsonReader parser = Json.createReader((InputStream)new GZIPInputStream(new FileInputStream(f)));){
                        JsonArray ary = parser.readObject().getJsonArray("compounds");
                        for (int k = 0; k < ary.size(); ++k) {
                            listener.newInChI(CompoundCandidate.fromJSON((JsonObject)ary.getJsonObject(k)).getInchi());
                        }
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }

        protected void init() {
            if (!this.currentPath.exists()) {
                this.currentPath.mkdirs();
                try {
                    this.writeSettings();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
                }
            } else {
                try {
                    this.database.readSettings();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
                }
            }
        }

        public void importFromString(String str) throws IOException {
            this.importFromString(str, null);
        }

        public void importFromString(String str, String id) throws IOException {
            if (str.startsWith("InChI")) {
                try {
                    IAtomContainer molecule = this.inChIGeneratorFactory.getInChIToStructure(str, SilentChemObjectBuilder.getInstance()).getAtomContainer();
                    if (id != null) {
                        molecule.setID(id);
                    }
                    this.addMolecule(molecule);
                }
                catch (CDKException e) {
                    throw new IOException(e);
                }
            }
            try {
                IAtomContainer molecule = this.smilesParser.parseSmiles(str);
                if (id != null) {
                    molecule.setID(id);
                }
                this.addMolecule(molecule);
            }
            catch (CDKException e) {
                throw new IOException(e);
            }
        }

        protected void importFrom(File file) throws IOException {
            block46: {
                ReaderFactory factory = new ReaderFactory();
                ISimpleChemObjectReader reader = null;
                try (FileInputStream stream = new FileInputStream(file);){
                    reader = factory.createReader((InputStream)stream);
                }
                if (reader != null) {
                    stream = new FileInputStream(file);
                    var5_5 = null;
                    try {
                        try {
                            reader.setReader((InputStream)stream);
                            IChemFile chemFile = (IChemFile)SilentChemObjectBuilder.getInstance().newInstance(IChemFile.class, new Object[0]);
                            chemFile = (IChemFile)reader.read((IChemObject)chemFile);
                            for (IChemSequence s : chemFile.chemSequences()) {
                                for (IChemModel m : s.chemModels()) {
                                    for (IAtomContainer c : m.getMoleculeSet().atomContainers()) {
                                        this.addMolecule(c);
                                    }
                                }
                            }
                            break block46;
                        }
                        catch (CDKException e) {
                            throw new IOException(e);
                        }
                    }
                    catch (Throwable e) {
                        var5_5 = e;
                        throw e;
                    }
                    finally {
                        if (stream != null) {
                            if (var5_5 != null) {
                                try {
                                    ((InputStream)stream).close();
                                }
                                catch (Throwable e) {
                                    var5_5.addSuppressed(e);
                                }
                            } else {
                                ((InputStream)stream).close();
                            }
                        }
                    }
                }
                BufferedReader br = new BufferedReader(new FileReader(file));
                String line = br.readLine();
                br.close();
                ArrayList mols = new ArrayList();
                if (line == null) {
                    throw new IOException("Unknown file format: " + file.getName());
                }
                if (line.contains("InChI")) {
                    for (String aline : Files.readAllLines(file.toPath(), Charset.forName("UTF-8"))) {
                        if ((aline = aline.trim()).isEmpty()) continue;
                        String id = null;
                        int index = aline.indexOf(9);
                        if (index >= 0) {
                            String[] parts = aline.split("\t");
                            aline = parts[0];
                            id = parts[1];
                        }
                        try {
                            IAtomContainer mol = this.inChIGeneratorFactory.getInChIToStructure(aline, SilentChemObjectBuilder.getInstance()).getAtomContainer();
                            if (id != null) {
                                mol.setID(id);
                            }
                            this.addMolecule(mol);
                        }
                        catch (CDKException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                } else {
                    try {
                        this.smilesParser.parseSmiles(line);
                        for (String aline : Files.readAllLines(file.toPath(), Charset.forName("UTF-8"))) {
                            if ((aline = aline.trim()).isEmpty()) continue;
                            String id = null;
                            int index = aline.indexOf(9);
                            if (index >= 0) {
                                String[] parts = aline.split("\t");
                                aline = parts[0];
                                id = parts[1];
                            }
                            try {
                                IAtomContainer mol = this.smilesParser.parseSmiles(aline);
                                if (id != null) {
                                    mol.setID(id);
                                }
                                this.addMolecule(mol);
                            }
                            catch (CDKException e) {
                                logger.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    catch (InvalidSmilesException e) {
                        throw new IOException("Unknown file format: " + file.getName());
                    }
                }
            }
        }

        private String getFirstMatchingProperty(IAtomContainer c, String[] propertyKeys) {
            for (String commonNameProp : propertyKeys) {
                String propValue = (String)c.getProperties().get(commonNameProp);
                if (propValue == null) continue;
                return propValue;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addMolecule(IAtomContainer mol) throws IOException {
            List<IAtomContainer> list = this.moleculeBuffer;
            synchronized (list) {
                this.moleculeBuffer.add(mol);
                for (ImporterListener l : this.listeners) {
                    l.newMoleculeBufferSize(this.moleculeBuffer.size());
                }
                if (this.moleculeBuffer.size() > 1000) {
                    this.flushMoleculeBuffer();
                }
            }
        }

        private void flushMoleculeBuffer() throws IOException {
            HashMap<String, Comp> dict = new HashMap<String, Comp>(this.moleculeBuffer.size());
            try {
                InChIGeneratorFactory icf = InChIGeneratorFactory.getInstance();
                for (IAtomContainer c : this.moleculeBuffer) {
                    try {
                        String key = icf.getInChIGenerator(c).getInchiKey().substring(0, 14);
                        Comp comp = new Comp(key);
                        comp.molecule = c;
                        dict.put(key, comp);
                    }
                    catch (IllegalArgumentException | CDKException e) {
                        logger.error(e.getMessage(), e);
                    }
                }
            }
            catch (IllegalArgumentException | CDKException e) {
                logger.error(e.getMessage(), e);
            }
            this.moleculeBuffer.clear();
            logger.info("Try downloading compounds");
            try {
                WebAPI webAPI = WebAPI.newInstance();
                Object object = null;
                try (RESTDatabase db2 = webAPI.getRESTDb(BioFilter.ALL, new File("."));){
                    try {
                        for (FingerprintCandidate fc : db2.lookupManyFingerprintsByInchis(dict.keySet())) {
                            logger.info(fc.getInchiKey2D() + " downloaded");
                            ((Comp)dict.get(fc.getInchiKey2D())).candidate = fc;
                        }
                    }
                    catch (DatabaseException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                catch (Throwable db2) {
                    object = db2;
                    throw db2;
                }
                finally {
                    if (webAPI != null) {
                        if (object != null) {
                            try {
                                webAPI.close();
                            }
                            catch (Throwable db2) {
                                ((Throwable)object).addSuppressed(db2);
                            }
                        } else {
                            webAPI.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            for (Comp c : dict.values()) {
                try {
                    this.addToBuffer(this.computeCompound(c.molecule, c.candidate));
                }
                catch (IllegalArgumentException | CDKException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            for (ImporterListener l : this.listeners) {
                l.newMoleculeBufferSize(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToBuffer(FingerprintCandidate fingerprintCandidate) throws IOException {
            List<FingerprintCandidate> list = this.buffer;
            synchronized (list) {
                this.buffer.add(fingerprintCandidate);
                for (ImporterListener l : this.listeners) {
                    l.newFingerprintBufferSize(this.buffer.size());
                    l.newInChI(fingerprintCandidate.getInchi());
                }
                if (this.buffer.size() > 10000) {
                    this.flushBuffer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected FingerprintCandidate computeCompound(IAtomContainer molecule, FingerprintCandidate fc) throws CDKException, IOException {
            DBLink[] ls;
            String commonName = this.getFirstMatchingProperty(molecule, this.commonNameProps);
            String id = this.getFirstMatchingProperty(molecule, this.dbIDProps);
            if (fc == null) {
                return this.computeCompound(molecule, id, commonName);
            }
            logger.info("download fingerprint " + fc.getInchiKey2D());
            if (fc.getLinks() == null) {
                fc.setLinks(new DBLink[0]);
            }
            if ((fc.getName() == null || fc.getName().isEmpty()) && commonName != null) {
                fc.setName(commonName);
            }
            if (id != null) {
                if (fc.getName() == null || fc.getName().isEmpty()) {
                    fc.setName(id);
                }
                ls = Arrays.copyOf(fc.getLinks(), fc.getLinks().length + 1);
                ls[ls.length - 1] = new DBLink(this.database.name, id);
                fc.setLinks(ls);
            } else {
                ls = Arrays.copyOf(fc.getLinks(), fc.getLinks().length + 1);
                ls[ls.length - 1] = new DBLink(this.database.name, "");
                fc.setLinks(ls);
            }
            fc.setBitset(fc.getBitset() | CustomDataSourceService.getSourceFromName(this.database.name).flag());
            List<FingerprintCandidate> list = this.buffer;
            synchronized (list) {
                this.buffer.add(fc);
                if (this.buffer.size() > 10000) {
                    this.flushBuffer();
                }
            }
            return fc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected FingerprintCandidate computeCompound(IAtomContainer molecule, String id, String commonName) throws CDKException, IllegalArgumentException, IOException {
            InChIGenerator gen = this.inChIGeneratorFactory.getInChIGenerator(molecule);
            InChI inchi = new InChI(gen.getInchiKey(), gen.getInchi());
            molecule = this.inChIGeneratorFactory.getInChIToStructure(inchi.in2D, SilentChemObjectBuilder.getInstance()).getAtomContainer();
            boolean[] fps = this.fingerprinter.fingerprintsToBooleans(this.fingerprinter.computeFingerprints(molecule));
            logger.info("compute fingerprint " + inchi.key2D());
            ArrayFingerprint fp = new BooleanFingerprint((FingerprintVersion)this.fingerprintVersion, fps).asArray();
            String smiles = this.smilesGen.create(molecule);
            FingerprintCandidate fc = new FingerprintCandidate(inchi, (Fingerprint)fp);
            fc.setSmiles(smiles);
            if (commonName != null) {
                fc.setName(commonName);
            }
            if (id != null) {
                fc.setLinks(new DBLink[]{new DBLink(this.database.name, id)});
                if (fc.getName() == null || fc.getName().isEmpty()) {
                    fc.setName(id);
                }
            } else {
                fc.setLinks(new DBLink[0]);
            }
            fc.setBitset(CustomDataSourceService.getSourceFromName(this.database.name).flag());
            XLogPDescriptor descriptor = new XLogPDescriptor();
            descriptor.setParameters(new Object[]{true, true});
            fc.setXlogp(((DoubleResult)descriptor.calculate(molecule).getValue()).doubleValue());
            List<FingerprintCandidate> list = this.buffer;
            synchronized (list) {
                this.buffer.add(fc);
                if (this.buffer.size() > 10000) {
                    this.flushBuffer();
                }
            }
            return fc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void flushBuffer() throws IOException {
            ArrayList<FingerprintCandidate> candidates;
            this.flushMoleculeBuffer();
            Object object = this.buffer;
            synchronized (object) {
                candidates = new ArrayList<FingerprintCandidate>(this.buffer);
                this.buffer.clear();
            }
            object = this.database;
            synchronized (object) {
                ArrayListMultimap candidatePerFormula = ArrayListMultimap.create();
                for (FingerprintCandidate fingerprintCandidate : candidates) {
                    candidatePerFormula.put((Object)fingerprintCandidate.getInchi().extractFormula(), (Object)fingerprintCandidate);
                }
                for (Map.Entry entry : candidatePerFormula.asMap().entrySet()) {
                    this.mergeCompounds((MolecularFormula)entry.getKey(), (Collection)entry.getValue());
                }
                for (ImporterListener importerListener : this.listeners) {
                    importerListener.newFingerprintBufferSize(this.buffer.size());
                }
                this.writeSettings();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mergeCompounds(MolecularFormula key, Collection<FingerprintCandidate> value) throws IOException {
            File file = new File(this.database.path, key.toString() + ".json.gz");
            try {
                ArrayList<FingerprintCandidate> candidates = new ArrayList<FingerprintCandidate>();
                candidates.addAll(value);
                CustomDatabase customDatabase = this.database;
                synchronized (customDatabase) {
                    this.database.numberOfCompounds += (long)Compound.merge((FingerprintVersion)this.fingerprintVersion, candidates, file);
                }
            }
            catch (IOException | JsonException e) {
                throw new IOException("Error while merging into " + file, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeSettings() throws IOException {
            CustomDatabase customDatabase = this.database;
            synchronized (customDatabase) {
                try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(this.database.settingsFile()));){
                    writer.beginObject();
                    writer.name("inheritance");
                    writer.beginArray();
                    if (this.database.deriveFromBioDb) {
                        writer.value(DatasourceService.Sources.BIO.name);
                    }
                    if (this.database.deriveFromPubchem) {
                        writer.value(DatasourceService.Sources.PUBCHEM.name);
                    }
                    writer.endArray();
                    writer.name("fingerprintVersion");
                    writer.beginArray();
                    for (int t = 0; t < this.fingerprintVersion.numberOfFingerprintTypesInUse(); ++t) {
                        writer.value(this.fingerprintVersion.getFingerprintTypeAt(t).name());
                    }
                    writer.endArray();
                    writer.name("schemaVersion");
                    writer.value(1L);
                    writer.name("statistics");
                    writer.beginObject();
                    writer.name("compounds");
                    writer.value(this.database.numberOfCompounds);
                    writer.endObject();
                    writer.endObject();
                }
            }
        }
    }

    public static abstract class AbstractImporterListener
    implements ImporterListener {
        @Override
        public void newFingerprintBufferSize(int size) {
        }

        @Override
        public void newMoleculeBufferSize(int size) {
        }

        @Override
        public void newInChI(InChI inchi) {
        }
    }

    public static interface ImporterListener {
        public void newFingerprintBufferSize(int var1);

        public void newMoleculeBufferSize(int var1);

        public void newInChI(InChI var1);
    }

    private static class Comp {
        private String inchikey;
        private IAtomContainer molecule;
        private FingerprintCandidate candidate;

        public Comp(String inchikey) {
            this.inchikey = inchikey;
        }
    }
}

