/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.db;

import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.chemdb.AnnotateStructures;
import de.unijena.bioinf.chemdb.CompoundCandidate;
import de.unijena.bioinf.chemdb.DatabaseException;
import de.unijena.bioinf.chemdb.FingerprintCandidate;
import de.unijena.bioinf.chemdb.SearchStructureByFormula;
import de.unijena.bioinf.fingerid.db.SearchableDatabase;
import de.unijena.bioinf.fingerid.net.CachedRESTDB;
import de.unijena.bioinf.fingerid.net.WebAPI;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class FingerblastSearchEngine
implements SearchStructureByFormula,
AnnotateStructures {
    protected final CachedRESTDB underlyingDatabase;
    protected final SearchableDatabase queryDB;

    public FingerblastSearchEngine(CachedRESTDB underlyingDatabase, SearchableDatabase queryDB) {
        this.underlyingDatabase = underlyingDatabase;
        this.queryDB = queryDB;
    }

    public void annotateCompounds(List<? extends CompoundCandidate> list) throws DatabaseException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Collection<FingerprintCandidate>> T lookupStructuresAndFingerprintsByFormula(MolecularFormula molecularFormula, T fingerprintCandidates) throws DatabaseException {
        try (WebAPI webAPI = WebAPI.newInstance();){
            fingerprintCandidates.addAll(this.underlyingDatabase.loadCompoundsByFormula(webAPI, molecularFormula, this.queryDB));
            T t = fingerprintCandidates;
            return t;
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }
}

