/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.jjobs;

import de.unijena.bioinf.ChemistryBase.fp.ClassyfireProperty;
import de.unijena.bioinf.ChemistryBase.fp.FPIter;
import de.unijena.bioinf.ChemistryBase.fp.ProbabilityFingerprint;
import de.unijena.bioinf.canopus.Canopus;
import de.unijena.bioinf.fingerid.CanopusResult;
import de.unijena.bioinf.fingerid.jjobs.FingerprintDependentJJob;
import de.unijena.bioinf.jjobs.JJob;
import de.unijena.bioinf.sirius.IdentificationResult;

public class CanopusJJob
extends FingerprintDependentJJob<CanopusResult> {
    private final Canopus canopus;

    public CanopusJJob(Canopus canopus) {
        this(canopus, null, null);
    }

    public CanopusJJob(Canopus canopus, IdentificationResult result, ProbabilityFingerprint fp) {
        super(JJob.JobType.CPU, result, fp);
        this.canopus = canopus;
    }

    protected CanopusResult compute() throws Exception {
        this.initInput();
        this.progressInfo("Predict compound categories for " + this.identificationResult.getMolecularFormula() + ": \nid\tname\tprobability");
        ProbabilityFingerprint fingerprint = this.canopus.predictClassificationFingerprint(this.identificationResult.getMolecularFormula(), this.fp);
        for (FPIter category : fingerprint.iterator()) {
            if (!(category.getProbability() >= 0.333)) continue;
            ClassyfireProperty prop = (ClassyfireProperty)category.getMolecularProperty();
            this.progressInfo(prop.getChemontIdentifier() + "\t" + prop.getName() + "\t" + (int)Math.round(100.0 * category.getProbability()) + " %");
        }
        return new CanopusResult(fingerprint);
    }
}

