/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.jjobs;

import de.unijena.bioinf.ChemistryBase.chem.PeriodicTable;
import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.fp.MaskedFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.ProbabilityFingerprint;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.MutableMs2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.PossibleAdducts;
import de.unijena.bioinf.ChemistryBase.ms.ft.IonTreeUtils;
import de.unijena.bioinf.FragmentationTreeConstruction.model.ProcessedInput;
import de.unijena.bioinf.canopus.Canopus;
import de.unijena.bioinf.chemdb.BioFilter;
import de.unijena.bioinf.chemdb.CompoundCandidateChargeState;
import de.unijena.bioinf.fingerid.FingerIdResult;
import de.unijena.bioinf.fingerid.blast.Fingerblast;
import de.unijena.bioinf.fingerid.db.FingerblastSearchEngine;
import de.unijena.bioinf.fingerid.db.SearchableDatabase;
import de.unijena.bioinf.fingerid.jjobs.CanopusJJob;
import de.unijena.bioinf.fingerid.jjobs.FingerblastJJob;
import de.unijena.bioinf.fingerid.jjobs.FingerprintDependentJJob;
import de.unijena.bioinf.fingerid.jjobs.FormulaJob;
import de.unijena.bioinf.fingerid.net.CachedRESTDB;
import de.unijena.bioinf.fingerid.net.WebAPI;
import de.unijena.bioinf.fingeriddb.job.UserDefineablePredictorType;
import de.unijena.bioinf.jjobs.BasicDependentMasterJJob;
import de.unijena.bioinf.jjobs.JJob;
import de.unijena.bioinf.sirius.IdentificationResult;
import de.unijena.bioinf.sirius.Sirius;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FingerIDJJob
extends BasicDependentMasterJJob<Map<IdentificationResult, ProbabilityFingerprint>> {
    private List<IdentificationResult> input = null;
    private Ms2Experiment experiment = null;
    private int maxResults = Integer.MAX_VALUE;
    private boolean filterIdentifications = true;
    private final Collection<UserDefineablePredictorType> predictors;
    private final MaskedFingerprintVersion fingerprintVersion;
    private final Fingerblast fingerblast;
    private long dbFlag = 0L;
    private BioFilter bioFilter = BioFilter.ALL;
    CachedRESTDB database;
    SearchableDatabase queryDb;
    private Canopus canopus = null;
    protected List<IdentificationResult> addedIdentificationResults = new ArrayList<IdentificationResult>();

    public FingerIDJJob(Fingerblast fingerblast, MaskedFingerprintVersion fingerprintVersion, CachedRESTDB database, SearchableDatabase queryDb, Collection<UserDefineablePredictorType> predictors) {
        super(JJob.JobType.CPU);
        this.fingerblast = fingerblast;
        this.fingerprintVersion = fingerprintVersion;
        this.predictors = predictors;
        this.database = database;
        this.queryDb = queryDb;
    }

    public void setInput(List<IdentificationResult> results, Ms2Experiment experiment) {
        this.input = results;
        this.experiment = experiment;
    }

    public void setDbFlag(long dbFlag) {
        this.dbFlag = dbFlag;
    }

    public void setCanopus(Canopus canopus) {
        this.canopus = canopus;
    }

    public void setBioFilter(BioFilter bioFilter) {
        this.bioFilter = bioFilter;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setFilterIdentifications(boolean filterIdentifications) {
        this.filterIdentifications = filterIdentifications;
    }

    public List<IdentificationResult> getAddedIdentificationResults() {
        return this.addedIdentificationResults;
    }

    /*
     * WARNING - void declaration
     */
    protected Map<IdentificationResult, ProbabilityFingerprint> compute() throws Exception {
        try (WebAPI webAPI = WebAPI.newInstance();){
            Sirius.SiriusIdentificationJob job;
            FingerblastSearchEngine searchStructureByFormula = this.database.getSearchEngine(this.queryDb);
            ArrayList<IdentificationResult> input = new ArrayList<IdentificationResult>();
            Ms2Experiment experiment = null;
            if (this.input != null) {
                input.addAll(this.input);
                experiment = this.experiment;
            }
            for (JJob j : this.getRequiredJobs()) {
                if (!(j instanceof Sirius.SiriusIdentificationJob)) continue;
                job = (Sirius.SiriusIdentificationJob)j;
                if (experiment == null) {
                    experiment = job.getExperiment();
                } else if (experiment != job.getExperiment()) {
                    throw new IllegalArgumentException("SiriusIdentificationJobs to collect are from different MS2Experments");
                }
                input.addAll((Collection)job.awaitResult());
            }
            if (input.isEmpty()) {
                Iterator iterator = null;
                return iterator;
            }
            Collections.sort(input);
            if (input.size() > this.maxResults) {
                input.subList(this.maxResults, input.size()).clear();
            }
            ArrayList<Object> filteredResults = new ArrayList<Object>();
            if (this.filterIdentifications && input.size() > 0) {
                IdentificationResult e;
                void var10_19;
                IdentificationResult top = (IdentificationResult)input.get(0);
                if (top == null || top.getResolvedTree() == null) {
                    job = null;
                    return job;
                }
                this.progressInfo("Filter Identification Results for CSI:FingerID usage");
                filteredResults.add(top);
                double threshold = Math.max(top.getScore(), 0.0) - Math.max(5.0, top.getScore() * 0.25);
                boolean bl = true;
                int n = input.size();
                while (var10_19 < n && !((e = (IdentificationResult)input.get((int)var10_19)).getScore() < threshold)) {
                    if (e.getResolvedTree() == null || e.getResolvedTree().numberOfVertices() <= 1) {
                        this.progressInfo("Cannot estimate structure for " + e.getMolecularFormula() + ". Fragmentation Tree is empty.");
                    } else {
                        filteredResults.add(e);
                    }
                    ++var10_19;
                }
            } else {
                filteredResults.addAll(input);
            }
            Iterator iter = filteredResults.iterator();
            while (iter.hasNext()) {
                IdentificationResult ir = (IdentificationResult)iter.next();
                if (ir.getBeautifulTree().numberOfVertices() >= 3) continue;
                this.progressInfo("Ignore " + ir.getMolecularFormula() + " because the tree contains less than 3 vertices");
                iter.remove();
            }
            if (filteredResults.isEmpty()) {
                this.progressInfo("No suitable fragmentation tree left.");
                Map<IdentificationResult, ProbabilityFingerprint> ir = Collections.emptyMap();
                return ir;
            }
            this.progressInfo("Search with CSI:FingerID");
            ArrayList<IdentificationResult> ionTypes = new ArrayList<IdentificationResult>();
            for (IdentificationResult identificationResult : filteredResults) {
                MutableMs2Experiment validatedExperiment;
                ProcessedInput pi = (ProcessedInput)identificationResult.getRawTree().getAnnotationOrNull(ProcessedInput.class);
                if (pi != null) {
                    validatedExperiment = pi.getExperimentInformation();
                } else {
                    this.LOG().info("FingerID job has no access to processed input data");
                    validatedExperiment = experiment;
                }
                PossibleAdducts adductTypes = (PossibleAdducts)validatedExperiment.getAnnotation(PossibleAdducts.class, (Object)new PossibleAdducts((Collection)PeriodicTable.getInstance().adductsByIonisation(experiment.getPrecursorIonType())));
                for (PrecursorIonType ionType : adductTypes) {
                    IdentificationResult newIr;
                    if (ionType.equals((PrecursorIonType)identificationResult.getBeautifulTree().getAnnotationOrThrow(PrecursorIonType.class)) || !new IonTreeUtils().isResolvable(identificationResult.getBeautifulTree(), ionType) || (newIr = IdentificationResult.withPrecursorIonType((IdentificationResult)identificationResult, (PrecursorIonType)ionType)).getResolvedTree().numberOfVertices() < 3) continue;
                    ionTypes.add(newIr);
                }
            }
            filteredResults.addAll(ionTypes);
            Collections.sort(filteredResults);
            this.addedIdentificationResults.addAll(ionTypes);
            ArrayList<WebAPI.PredictionJJob> predictionJobs = new ArrayList<WebAPI.PredictionJJob>();
            ArrayList<FingerprintDependentJJob> arrayList = new ArrayList<FingerprintDependentJJob>();
            for (Object fingeridInput : filteredResults) {
                WebAPI.PredictionJJob predictionJob = webAPI.makePredictionJob(experiment, (IdentificationResult)fingeridInput, fingeridInput.getResolvedTree(), this.fingerprintVersion, this.predictors);
                this.submitSubJob((JJob)predictionJob);
                predictionJobs.add(predictionJob);
                FormulaJob formulaJob = new FormulaJob(fingeridInput.getMolecularFormula(), searchStructureByFormula, fingeridInput.getPrecursorIonType());
                PrecursorIonType ionType = (PrecursorIonType)fingeridInput.getResolvedTree().getAnnotationOrThrow(PrecursorIonType.class);
                FingerblastJJob blastJob = new FingerblastJJob(this.fingerblast, this.bioFilter, this.dbFlag, CompoundCandidateChargeState.getFromPrecursorIonType((PrecursorIonType)ionType));
                blastJob.addRequiredJob((JJob)formulaJob);
                blastJob.addRequiredJob((JJob)predictionJob);
                this.submitSubJob((JJob)formulaJob);
                this.submitSubJob((JJob)blastJob);
                arrayList.add(blastJob);
                if (this.canopus == null) continue;
                CanopusJJob canopusJob = new CanopusJJob(this.canopus);
                canopusJob.addRequiredJob((JJob)predictionJob);
                this.submitSubJob((JJob)canopusJob);
                arrayList.add(canopusJob);
            }
            HashMap<IdentificationResult, ProbabilityFingerprint> fps = new HashMap<IdentificationResult, ProbabilityFingerprint>(input.size());
            for (WebAPI.PredictionJJob predictionJob : predictionJobs) {
                ProbabilityFingerprint r = (ProbabilityFingerprint)predictionJob.awaitResult();
                if (r == null) continue;
                fps.put(predictionJob.result, r);
            }
            for (FingerprintDependentJJob job2 : arrayList) {
                job2.takeAndAnnotateResult();
            }
            ArrayList<IdentificationResult> toDelete = new ArrayList<IdentificationResult>();
            for (IdentificationResult ar : this.addedIdentificationResults) {
                FingerIdResult fr = (FingerIdResult)ar.getAnnotationOrNull(FingerIdResult.class);
                if (fr != null && !fr.getCandidates().isEmpty()) continue;
                toDelete.add(ar);
            }
            this.addedIdentificationResults.removeAll(toDelete);
            filteredResults.removeAll(toDelete);
            HashMap<IdentificationResult, ProbabilityFingerprint> hashMap = fps;
            return hashMap;
        }
    }
}

