/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.jjobs;

import de.unijena.bioinf.ChemistryBase.algorithm.Scored;
import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.fp.ProbabilityFingerprint;
import de.unijena.bioinf.chemdb.BioFilter;
import de.unijena.bioinf.chemdb.CompoundCandidateChargeState;
import de.unijena.bioinf.chemdb.FingerprintCandidate;
import de.unijena.bioinf.fingerid.FingerIdResult;
import de.unijena.bioinf.fingerid.blast.Fingerblast;
import de.unijena.bioinf.fingerid.jjobs.FingerprintDependentJJob;
import de.unijena.bioinf.fingerid.jjobs.FormulaJob;
import de.unijena.bioinf.jjobs.JJob;
import de.unijena.bioinf.sirius.IdentificationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class FingerblastJJob
extends FingerprintDependentJJob<FingerIdResult> {
    private final Fingerblast fingerblast;
    private final boolean filter;
    private final long flag;
    private final CompoundCandidateChargeState chargeState;
    protected List<FingerprintCandidate> searchList;

    public FingerblastJJob(Fingerblast fingerblast, BioFilter bioFilter, long flag, CompoundCandidateChargeState chargeState) {
        this(fingerblast, bioFilter, flag, null, null, null, chargeState);
    }

    public FingerblastJJob(Fingerblast fingerblast, BioFilter bioFilter, long flag, IdentificationResult result, ProbabilityFingerprint fp, MolecularFormula formula, CompoundCandidateChargeState chargeState) {
        this(fingerblast, bioFilter != BioFilter.ALL, flag, result, fp, formula, chargeState);
    }

    public FingerblastJJob(Fingerblast fingerblast, boolean bioFilter, long flag, IdentificationResult result, ProbabilityFingerprint fp, MolecularFormula formula, CompoundCandidateChargeState chargeState) {
        super(JJob.JobType.CPU, result, fp);
        this.fingerblast = fingerblast;
        this.filter = bioFilter;
        this.flag = flag;
        this.formula = formula;
        this.chargeState = chargeState;
    }

    @Override
    protected void initInput() throws ExecutionException {
        super.initInput();
        if (this.searchList == null) {
            List requireJobs = this.getRequiredJobs();
            for (JJob j : requireJobs) {
                if (!(j instanceof FormulaJob)) continue;
                FormulaJob job = (FormulaJob)j;
                this.searchList = (List)job.awaitResult();
            }
        }
    }

    protected FingerIdResult compute() throws Exception {
        this.initInput();
        ArrayList<FingerprintCandidate> searchList = new ArrayList<FingerprintCandidate>(this.searchList.size());
        for (FingerprintCandidate c : this.searchList) {
            if (this.filter && this.flag != 0L && (c.getBitset() & this.flag) == 0L) continue;
            searchList.add(c);
        }
        List cds = this.fingerblast.score(searchList, this.fp);
        Collections.sort(cds, Scored.desc());
        return new FingerIdResult(cds, 0.0, this.fp, this.resolvedTree);
    }
}

