/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.jjobs;

import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.fp.ProbabilityFingerprint;
import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.fingerid.net.WebAPI;
import de.unijena.bioinf.jjobs.BasicDependentJJob;
import de.unijena.bioinf.jjobs.JJob;
import de.unijena.bioinf.sirius.IdentificationResult;
import de.unijena.bioinf.sirius.IdentificationResultAnnotationJJob;
import java.util.List;
import java.util.concurrent.ExecutionException;

public abstract class FingerprintDependentJJob<R>
extends BasicDependentJJob<R>
implements IdentificationResultAnnotationJJob<R> {
    protected IdentificationResult identificationResult;
    protected ProbabilityFingerprint fp;
    protected MolecularFormula formula;
    protected FTree resolvedTree;

    protected FingerprintDependentJJob(JJob.JobType type, IdentificationResult result, ProbabilityFingerprint fp) {
        super(type);
        this.identificationResult = result;
        this.fp = fp;
    }

    protected void initInput() throws ExecutionException {
        if (this.identificationResult == null || this.fp == null) {
            List requiredJobs = this.getRequiredJobs();
            for (JJob j : requiredJobs) {
                if (!(j instanceof WebAPI.PredictionJJob)) continue;
                WebAPI.PredictionJJob job = (WebAPI.PredictionJJob)j;
                if (job.result == null || job.awaitResult() == null) continue;
                this.identificationResult = job.result;
                this.fp = (ProbabilityFingerprint)job.awaitResult();
                this.resolvedTree = job.ftree;
                this.formula = job.ftree.getRoot().getFormula();
                return;
            }
            throw new IllegalArgumentException("No Input Data found. " + requiredJobs.toString());
        }
    }

    public IdentificationResult getIdentificationResult() {
        return this.identificationResult;
    }
}

