/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.jjobs;

import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.chemdb.CompoundCandidateChargeLayer;
import de.unijena.bioinf.chemdb.CompoundCandidateChargeState;
import de.unijena.bioinf.chemdb.FingerprintCandidate;
import de.unijena.bioinf.chemdb.SearchStructureByFormula;
import de.unijena.bioinf.jjobs.BasicJJob;
import de.unijena.bioinf.jjobs.JJob;
import java.util.List;

public class FormulaJob
extends BasicJJob<List<FingerprintCandidate>> {
    protected final MolecularFormula formula;
    protected final SearchStructureByFormula searchDatabase;
    protected final PrecursorIonType ionType;

    public FormulaJob(MolecularFormula formula, SearchStructureByFormula searchDatabase, PrecursorIonType precursorIonType) {
        super(JJob.JobType.REMOTE);
        this.formula = formula;
        this.searchDatabase = searchDatabase;
        this.ionType = precursorIonType;
    }

    protected List<FingerprintCandidate> compute() throws Exception {
        CompoundCandidateChargeState chargeState = CompoundCandidateChargeState.getFromPrecursorIonType((PrecursorIonType)this.ionType);
        if (chargeState != CompoundCandidateChargeState.NEUTRAL_CHARGE) {
            List intrinsic = this.searchDatabase.lookupStructuresAndFingerprintsByFormula(this.formula);
            intrinsic.removeIf(f -> !f.hasChargeState(CompoundCandidateChargeLayer.Q_LAYER, chargeState));
            MolecularFormula hydrogen = MolecularFormula.parse((String)"H");
            List protonated = this.searchDatabase.lookupStructuresAndFingerprintsByFormula(this.ionType.getCharge() > 0 ? this.formula.subtract(hydrogen) : this.formula.add(hydrogen));
            protonated.removeIf(f -> !f.hasChargeState(CompoundCandidateChargeLayer.P_LAYER, chargeState));
            intrinsic.addAll(protonated);
            return intrinsic;
        }
        List candidates = this.searchDatabase.lookupStructuresAndFingerprintsByFormula(this.formula);
        candidates.removeIf(f -> !f.hasChargeState(CompoundCandidateChargeLayer.P_LAYER, CompoundCandidateChargeState.NEUTRAL_CHARGE));
        return candidates;
    }
}

