/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.net;

import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.fp.FingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.MaskedFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.properties.PropertyManager;
import de.unijena.bioinf.ChemistryBase.utils.FileUtils;
import de.unijena.bioinf.chemdb.BioFilter;
import de.unijena.bioinf.chemdb.DatabaseException;
import de.unijena.bioinf.chemdb.FileCompoundStorage;
import de.unijena.bioinf.chemdb.FingerprintCandidate;
import de.unijena.bioinf.chemdb.RESTDatabase;
import de.unijena.bioinf.fingerid.db.FingerblastSearchEngine;
import de.unijena.bioinf.fingerid.db.SearchableDatabase;
import de.unijena.bioinf.fingerid.net.VersionsInfo;
import de.unijena.bioinf.fingerid.net.WebAPI;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedRESTDB {
    protected static Logger logger = LoggerFactory.getLogger(CachedRESTDB.class);
    protected File directory;
    protected MaskedFingerprintVersion fingerprintVersion;
    protected HashMap<String, FileCompoundStorage> customDatabases;
    protected VersionsInfo versionsInfo;

    public CachedRESTDB(VersionsInfo versionsInfo, MaskedFingerprintVersion fingerprintVersion) {
        this(versionsInfo, fingerprintVersion, CachedRESTDB.getDefaultDirectory());
    }

    public CachedRESTDB(VersionsInfo versionsInfo, MaskedFingerprintVersion fingerprintVersion, File dir) {
        this.versionsInfo = versionsInfo;
        this.fingerprintVersion = fingerprintVersion;
        this.directory = dir;
        this.customDatabases = new HashMap();
    }

    public static File getDefaultDirectory() {
        String val = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.fingerID.cache");
        return Paths.get(val, new String[0]).toFile();
    }

    public void checkCache() throws IOException {
        if (this.isOutdated()) {
            this.destroyCache();
        }
    }

    public boolean isOutdated() {
        File f = new File(this.directory, "version");
        if (f.exists()) {
            try {
                List<String> content = Files.readAllLines(f.toPath(), Charset.forName("UTF-8"));
                if (content.size() > 0 && !this.versionsInfo.databaseOutdated(content.get(0))) {
                    return false;
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    public FingerblastSearchEngine getSearchEngine(SearchableDatabase db) {
        return new FingerblastSearchEngine(this, db);
    }

    protected File getBioDirectory() {
        return new File(this.directory, "bio");
    }

    protected File getNonBioDirectory() {
        return new File(this.directory, "not-bio");
    }

    protected File getCustomDirectory(String name) {
        return new File(new File(this.directory, "custom"), name);
    }

    public void destroyCache() throws IOException {
        File bio = this.getBioDirectory();
        File nonBio = this.getNonBioDirectory();
        if (bio.exists() || nonBio.exists()) {
            logger.info("Destroy database cache, due to updated online database.");
        }
        if (bio.exists()) {
            for (File f : bio.listFiles()) {
                Files.deleteIfExists(f.toPath());
            }
        }
        if (nonBio.exists()) {
            for (File f : nonBio.listFiles()) {
                Files.deleteIfExists(f.toPath());
            }
        }
        if (!this.directory.exists()) {
            this.directory.mkdirs();
            bio.mkdirs();
            nonBio.mkdirs();
        }
        try (BufferedWriter bw = Files.newBufferedWriter(new File(this.directory, "version").toPath(), Charset.forName("UTF-8"), new OpenOption[0]);){
            bw.write(this.versionsInfo.databaseDate);
        }
    }

    public List<FingerprintCandidate> loadCompoundsByFormula(WebAPI webAPI, MolecularFormula formula, SearchableDatabase db) throws IOException {
        ArrayList<FingerprintCandidate> candidates = new ArrayList<FingerprintCandidate>();
        try {
            if (db.searchInPubchem()) {
                this.search(webAPI, formula, candidates, true);
                this.search(webAPI, formula, candidates, false);
            } else if (db.searchInBio()) {
                this.search(webAPI, formula, candidates, true);
            }
            if (db.isCustomDb()) {
                this.search(webAPI, formula, candidates, this.getCustomDb(db));
            }
        }
        catch (DatabaseException e) {
            throw new IOException(e);
        }
        return this.mergeCompounds(candidates);
    }

    protected FileCompoundStorage getCustomDb(SearchableDatabase db) throws IOException {
        if (this.customDatabases.containsKey(db.name())) {
            return this.customDatabases.get(db.name());
        }
        FileCompoundStorage custom = new FileCompoundStorage(db.getDatabasePath(), this.fingerprintVersion.getMaskedFingerprintVersion());
        this.customDatabases.put(db.name(), custom);
        return custom;
    }

    private void search(WebAPI webAPI, MolecularFormula formula, List<FingerprintCandidate> candidates, boolean isBio) throws IOException, DatabaseException {
        File f = new File(isBio ? this.getBioDirectory() : this.getNonBioDirectory(), formula.toString() + ".json.gz");
        if (f.exists()) {
            try {
                this.parseJson(f, candidates);
                return;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(CachedRESTDB.class).error(e.getMessage(), (Throwable)e);
                f.delete();
            }
        }
        try (RESTDatabase restDb = webAPI.getRESTDb(isBio ? BioFilter.ONLY_BIO : BioFilter.ONLY_NONBIO, this.directory);){
            candidates.addAll(restDb.lookupStructuresAndFingerprintsByFormula(formula));
        }
    }

    private void search(WebAPI webAPI, MolecularFormula formula, List<FingerprintCandidate> candidates, FileCompoundStorage db) throws IOException, DatabaseException {
        candidates.addAll(db.lookupStructuresAndFingerprintsByFormula(formula));
    }

    private void parseJson(File f, List<FingerprintCandidate> candidates) throws IOException {
        try (BufferedReader reader = FileUtils.getReader((File)f);){
            JsonObject obj = Json.createReader((Reader)reader).readObject();
            JsonArray array = obj.getJsonArray("compounds");
            for (int i = 0; i < array.size(); ++i) {
                candidates.add(FingerprintCandidate.fromJSON((FingerprintVersion)this.fingerprintVersion.getMaskedFingerprintVersion(), (JsonObject)array.getJsonObject(i)));
            }
        }
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    private List<FingerprintCandidate> mergeCompounds(List<FingerprintCandidate> compounds) {
        HashMap<String, FingerprintCandidate> cs = new HashMap<String, FingerprintCandidate>();
        for (FingerprintCandidate c : compounds) {
            FingerprintCandidate x = (FingerprintCandidate)cs.get(c.getInchiKey2D());
            if (x != null) continue;
            cs.put(c.getInchi().key2D(), c);
        }
        return new ArrayList<FingerprintCandidate>(cs.values());
    }
}

