/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.net;

import de.unijena.bioinf.fingerid.net.News;
import de.unijena.bioinf.sirius.core.ApplicationCore;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class VersionsInfo {
    public static final int CUSTOM_DATABASE_SCHEMA = 1;
    public String databaseDate;
    public final DefaultArtifactVersion siriusGuiVersion;
    public final boolean expired;
    public final Timestamp acceptJobs;
    public final Timestamp finishJobs;
    protected List<News> newsList;

    public VersionsInfo(String siriusGuiVersion, String databaseDate, boolean expired) {
        this(siriusGuiVersion, databaseDate, expired, null, null, Collections.emptyList());
    }

    public VersionsInfo(String siriusGuiVersion, String databaseDate, boolean expired, Timestamp acceptJobs, Timestamp finishJobs) {
        this(siriusGuiVersion, databaseDate, expired, acceptJobs, finishJobs, Collections.emptyList());
    }

    public VersionsInfo(String siriusGuiVersion, String databaseDate, boolean expired, Timestamp acceptJobs, Timestamp finishJobs, List<News> newsList) {
        this.siriusGuiVersion = new DefaultArtifactVersion(siriusGuiVersion);
        this.databaseDate = databaseDate;
        this.expired = expired;
        this.acceptJobs = acceptJobs;
        this.finishJobs = finishJobs;
        this.newsList = this.filterNews(newsList);
    }

    private List<News> filterNews(List<News> newsList) {
        ArrayList<News> filteredNews = new ArrayList<News>();
        String property = "de.unijena.bioinf.sirius.news";
        Properties properties = ApplicationCore.SIRIUS_PROPERTIES_FILE.getCopyOfPersistentProperties();
        String propertyValue = properties.getProperty("de.unijena.bioinf.sirius.news", "");
        HashSet<String> knownNews = new HashSet<String>(Arrays.asList(propertyValue.split(",")));
        for (News news : newsList) {
            if (knownNews.contains(news.getId())) continue;
            filteredNews.add(news);
        }
        return filteredNews;
    }

    public boolean outdated() {
        return this.expired() && !this.finishJobs();
    }

    public boolean expired() {
        return this.expired;
    }

    public boolean acceptJobs() {
        if (this.acceptJobs == null) {
            return false;
        }
        return this.acceptJobs.getTime() >= System.currentTimeMillis();
    }

    public boolean finishJobs() {
        if (this.finishJobs == null) {
            return false;
        }
        return this.finishJobs.getTime() >= System.currentTimeMillis();
    }

    public boolean hasNews() {
        return this.newsList != null && this.newsList.size() > 0;
    }

    public List<News> getNews() {
        return this.newsList;
    }

    public boolean databaseOutdated(String s) {
        return this.databaseDate.compareTo(s) > 0;
    }

    public String toString() {
        return "Sirius-gui-version: " + this.siriusGuiVersion + ", Database-date: " + this.databaseDate + ", isExpired: " + this.expired + ", acceptJobs: " + (this.acceptJobs != null ? this.acceptJobs.toString() : "NULL") + ", finishJobs: " + (this.finishJobs != null ? this.finishJobs.toString() : "NULL");
    }
}

