/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.net;

import com.google.gson.JsonParser;
import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.fp.CdkFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.FingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.MaskedFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.PredictionPerformance;
import de.unijena.bioinf.ChemistryBase.fp.ProbabilityFingerprint;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.ChemistryBase.properties.PropertyManager;
import de.unijena.bioinf.ConfidenceScore.QueryPredictor;
import de.unijena.bioinf.chemdb.BioFilter;
import de.unijena.bioinf.chemdb.RESTDatabase;
import de.unijena.bioinf.fingerid.Compound;
import de.unijena.bioinf.fingerid.blast.CovarianceScoring;
import de.unijena.bioinf.fingerid.net.FingerIdJob;
import de.unijena.bioinf.fingerid.net.VersionsInfo;
import de.unijena.bioinf.fingerid.utils.FingerIDProperties;
import de.unijena.bioinf.fingeriddb.job.PredictorType;
import de.unijena.bioinf.fingeriddb.job.UserDefineablePredictorType;
import de.unijena.bioinf.jjobs.BasicJJob;
import de.unijena.bioinf.jjobs.JJob;
import de.unijena.bioinf.jjobs.JobManager;
import de.unijena.bioinf.sirius.IdentificationResult;
import de.unijena.bioinf.sirius.net.ProxyManager;
import de.unijena.bioinf.utils.errorReport.ErrorReport;
import de.unijena.bioinf.utils.systemInfo.SystemInformation;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import net.iharder.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public class WebAPI
implements Closeable {
    private static final LinkedHashSet<WebAPI> INSTANCES = new LinkedHashSet();
    private static final BasicNameValuePair UID = new BasicNameValuePair("uid", SystemInformation.generateSystemKey());
    public static final DefaultArtifactVersion VERSION = new DefaultArtifactVersion(PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.version"));
    public static final String SIRIUS_DOWNLOAD = "https://bio.informatik.uni-jena.de/software/sirius/";
    public static final String FINGERID_WEB_API = FingerIDProperties.fingeridWebHost();
    private CloseableHttpClient client = ProxyManager.getSirirusHttpClient();
    public static final int MAX_STATE = 6;

    public static WebAPI newInstance() {
        WebAPI i = new WebAPI();
        INSTANCES.add(i);
        return i;
    }

    public static void reconnectAllInstances() {
        for (WebAPI api : INSTANCES) {
            api.reconnect();
        }
    }

    private WebAPI() {
    }

    @Override
    public void close() throws IOException {
        this.client.close();
        INSTANCES.remove(this);
    }

    public boolean isConnected() {
        if (this.client == null || this.checkConnection() == 0) {
            LoggerFactory.getLogger(this.getClass()).warn("No Connection, try to reconnect");
            this.reconnect();
            return this.checkConnection() == 0;
        }
        return true;
    }

    public void reconnect() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not close Existing connection!", (Throwable)e);
            }
        }
        this.client = ProxyManager.getSirirusHttpClient();
    }

    private boolean checkFingerIDConnection() {
        return this.getRESTDb(BioFilter.ALL, null).testConnection();
    }

    public int checkConnection() {
        VersionsInfo v = this.getVersionInfo();
        if (v == null) {
            int error = ProxyManager.checkInternetConnection(this.client);
            if (error > 0) {
                return error;
            }
            return 4;
        }
        if (v.outdated()) {
            return 6;
        }
        if (this.checkFingerIDConnection()) {
            return 0;
        }
        return 5;
    }

    public static int checkFingerIDConnectionStatic() {
        int errorcode = 1;
        try (WebAPI web = WebAPI.newInstance();){
            errorcode = web.checkConnection();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(WebAPI.class).error("Unexpected WebAPI error during connection check", (Throwable)e);
        }
        return errorcode;
    }

    public static boolean canConnect() {
        return WebAPI.checkFingerIDConnectionStatic() == 0;
    }

    public VersionsInfo getVersionInfo() {
        VersionsInfo v = null;
        try {
            v = this.getVersionInfo(new HttpGet(WebAPI.getFingerIdVersionURI(WebAPI.getFingerIdBaseURI()).setParameter("fingeridVersion", FingerIDProperties.fingeridVersion()).setParameter("siriusguiVersion", FingerIDProperties.sirius_guiVersion()).build()));
            if (v == null) {
                LoggerFactory.getLogger(this.getClass()).warn("Could not reach fingerid root url for version verification. Try to reach version specific url");
                v = this.getVersionInfo(new HttpGet(WebAPI.getFingerIdVersionURI(WebAPI.getFingerIdURI(null)).build()));
            }
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
        if (v != null) {
            LoggerFactory.getLogger(this.getClass()).debug(v.toString());
        }
        return v;
    }

    /*
     * Exception decompiling
     */
    private VersionsInfo getVersionInfo(HttpGet get) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static URIBuilder getFingerIdURI(String path) {
        if (path == null) {
            path = "";
        }
        URIBuilder b = null;
        try {
            b = WebAPI.getFingerIdBaseURI();
            b = b.setPath("/csi-fingerid-" + FingerIDProperties.fingeridVersion() + path);
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger(WebAPI.class).error("Unacceptable URI for CSI:FingerID", (Throwable)e);
        }
        return b;
    }

    private static URIBuilder getFingerIdVersionURI(URIBuilder baseBuilder) {
        baseBuilder = baseBuilder.setPath("/webapi/version.json");
        return baseBuilder;
    }

    private static URIBuilder getFingerIdBaseURI() throws URISyntaxException {
        URIBuilder b = new URIBuilder(FINGERID_WEB_API);
        return b;
    }

    public RESTDatabase getRESTDb(BioFilter bioFilter, File cacheDir) {
        URI host = null;
        try {
            host = WebAPI.getFingerIdURI(null).build();
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Illegal fingerid URI -> Fallback to RestDB Default URI", (Throwable)e);
        }
        return new RESTDatabase(cacheDir, bioFilter, host, this.client);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateJobStatus(FingerIdJob job) throws URISyntaxException, IOException {
        HttpGet get = new HttpGet(WebAPI.getFingerIdURI("/webapi/job.json").setParameter("jobId", String.valueOf(job.jobId)).setParameter("securityToken", job.securityToken).build());
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);
             JsonReader json = Json.createReader((Reader)new BufferedReader(new InputStreamReader(response.getEntity().getContent(), ContentType.getOrDefault((HttpEntity)response.getEntity()).getCharset())));){
            JsonObject obj = json.readObject();
            if (obj.containsKey((Object)"prediction")) {
                byte[] plattBytes = Base64.decode((String)obj.getString("prediction"));
                double[] platts = this.parseBinaryToDoubles(plattBytes);
                job.prediction = new ProbabilityFingerprint((FingerprintVersion)job.version, platts);
                if (obj.containsKey((Object)"iokrVector")) {
                    byte[] iokrBytes = Base64.decode((String)obj.getString("iokrVector"));
                    job.iokrVerctor = this.parseBinaryToDoubles(iokrBytes);
                }
                boolean bl = true;
                return bl;
            }
            job.state = obj.containsKey((Object)"state") ? obj.getString("state") : "SUBMITTED";
            if (!obj.containsKey((Object)"errors")) return false;
            job.errorMessage = obj.getString("errors");
            return false;
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(this.getClass()).error("Error when updating job #" + job.jobId, t);
            throw t;
        }
    }

    double[] parseBinaryToDoubles(byte[] bytes) {
        TDoubleArrayList data = new TDoubleArrayList(2000);
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        while (buf.position() < buf.limit()) {
            data.add(buf.getDouble());
        }
        return data.toArray();
    }

    /*
     * Exception decompiling
     */
    public FingerIdJob submitJob(Ms2Experiment experiment, FTree ftree, MaskedFingerprintVersion version, @NotNull EnumSet<PredictorType> types) throws IOException, URISyntaxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Future<ProbabilityFingerprint> predictFingerprint(@NotNull ExecutorService service, Ms2Experiment experiment, FTree tree, MaskedFingerprintVersion version, EnumSet<PredictorType> predicors) {
        return service.submit(new PredictionJJob(experiment, null, tree, version, predicors));
    }

    public PredictionJJob predictFingerprint(@NotNull JobManager manager, Ms2Experiment experiment, FTree tree, MaskedFingerprintVersion version, EnumSet<PredictorType> predicors) {
        return this.predictFingerprint(manager, experiment, tree, version, predicors);
    }

    public PredictionJJob predictFingerprint(@NotNull JobManager manager, Ms2Experiment experiment, IdentificationResult result, MaskedFingerprintVersion version, EnumSet<PredictorType> predicors) {
        return this.predictFingerprint(manager, experiment, result, result.getResolvedTree(), version, predicors);
    }

    public PredictionJJob predictFingerprint(@NotNull JobManager manager, Ms2Experiment experiment, IdentificationResult result, FTree tree, MaskedFingerprintVersion version, EnumSet<PredictorType> predicors) {
        PredictionJJob jjob = this.makePredictionJob(experiment, result, tree, version, predicors);
        manager.submitJob((JJob)jjob);
        return jjob;
    }

    public PredictionJJob makePredictionJob(Ms2Experiment experiment, IdentificationResult result, FTree tree, MaskedFingerprintVersion version, Collection<UserDefineablePredictorType> predicors) {
        return this.makePredictionJob(experiment, result, tree, version, UserDefineablePredictorType.toPredictorTypes((PrecursorIonType)result.getPrecursorIonType(), predicors));
    }

    public PredictionJJob makePredictionJob(Ms2Experiment experiment, IdentificationResult result, FTree tree, MaskedFingerprintVersion version, EnumSet<PredictorType> predicors) {
        return new PredictionJJob(experiment, result, tree, version, predicors);
    }

    public static FingerprintVersion getFingerprintVersion() {
        return CdkFingerprintVersion.withECFP();
    }

    public PredictionPerformance[] getStatistics(PredictorType predictorType, TIntArrayList fingerprintIndizes) throws IOException {
        HttpGet get;
        fingerprintIndizes.clear();
        try {
            get = new HttpGet(WebAPI.getFingerIdURI("/webapi/statistics.csv").setParameter("predictor", predictorType.toBitsAsString()).build());
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        TIntArrayList[] lists = new TIntArrayList[5];
        ArrayList<PredictionPerformance> performances = new ArrayList<PredictionPerformance>();
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);){
            String line;
            HttpEntity e = response.getEntity();
            BufferedReader br = new BufferedReader(new InputStreamReader(e.getContent(), ContentType.getOrDefault((HttpEntity)e).getCharset()));
            while ((line = br.readLine()) != null) {
                String[] tabs = line.split("\t");
                int index = Integer.parseInt(tabs[0]);
                PredictionPerformance p = new PredictionPerformance(Double.parseDouble(tabs[1]), Double.parseDouble(tabs[2]), Double.parseDouble(tabs[3]), Double.parseDouble(tabs[4]));
                performances.add(p);
                fingerprintIndizes.add(index);
            }
        }
        return performances.toArray(new PredictionPerformance[performances.size()]);
    }

    public CovarianceScoring getCovarianceScoring(FingerprintVersion fpVersion, double alpha) throws IOException {
        CovarianceScoring covarianceScoring;
        HttpGet get;
        try {
            get = new HttpGet(WebAPI.getFingerIdURI("/webapi/covariancetree.csv").build());
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);){
            if (!this.isSuccessful((HttpResponse)response)) {
                throw new IOException("Cannot get covariance scoring tree information.");
            }
            HttpEntity e = response.getEntity();
            covarianceScoring = CovarianceScoring.readScoring((InputStream)e.getContent(), (Charset)ContentType.getOrDefault((HttpEntity)e).getCharset(), (FingerprintVersion)fpVersion, (double)alpha);
        }
        return covarianceScoring;
    }

    /*
     * Exception decompiling
     */
    public List<Compound> getCompoundsFor(MolecularFormula formula, File output, MaskedFingerprintVersion version, boolean bio) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueryPredictor getConfidenceScore(boolean bio) {
        try {
            HttpGet get = new HttpGet(WebAPI.getFingerIdURI("/webapi/confidence.json").setParameter("bio", String.valueOf(bio)).build());
            try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);){
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), Charset.forName("UTF-8")));
                QueryPredictor qp = QueryPredictor.loadFromStream((Reader)br);
                br.close();
                QueryPredictor queryPredictor = qp;
                return queryPredictor;
            }
            catch (ClientProtocolException e) {
                LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
                return null;
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public <T extends ErrorReport> String reportError(T report, String SOFTWARE_NAME) throws IOException, URISyntaxException {
        HttpPost request = new HttpPost(WebAPI.getFingerIdURI("/webapi/report.json").build());
        String json = ErrorReport.toJson(report);
        BasicNameValuePair reportValue = new BasicNameValuePair("report", json);
        BasicNameValuePair softwareName = new BasicNameValuePair("name", SOFTWARE_NAME);
        UrlEncodedFormEntity params = new UrlEncodedFormEntity(Arrays.asList(reportValue, softwareName));
        request.setEntity((HttpEntity)params);
        Throwable throwable = null;
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            if (response.getStatusLine().getStatusCode() == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), Charset.forName("UTF-8")));
                com.google.gson.JsonObject o = new JsonParser().parse(br.readLine()).getAsJsonObject();
                boolean suc = o.get("success").getAsBoolean();
                String m = o.get("message").getAsString();
                if (suc) {
                    LoggerFactory.getLogger(this.getClass()).info(m);
                } else {
                    LoggerFactory.getLogger(this.getClass()).error(m);
                }
                String string = m;
                return string;
            }
            try {
                RuntimeException e = new RuntimeException(response.getStatusLine().getReasonPhrase());
                LoggerFactory.getLogger(this.getClass()).error("Could not send error report! Bad http return Value: " + response.getStatusLine().getStatusCode(), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private boolean isSuccessful(HttpResponse response) {
        return response.getStatusLine().getStatusCode() < 400;
    }

    private static class MultiplexerFileAndIO
    extends InputStream
    implements Closeable {
        private final byte[] buffer = new byte[524288];
        private final InputStream stream;
        private final OutputStream writer;
        private int offset;
        private int limit;
        private boolean closed = false;

        private MultiplexerFileAndIO(InputStream stream, OutputStream writer) throws IOException {
            this.stream = stream;
            this.writer = writer;
            this.offset = 0;
            this.limit = 0;
            this.fillCache();
        }

        private boolean fillCache() throws IOException {
            this.limit = this.stream.read(this.buffer, 0, this.buffer.length);
            this.offset = 0;
            if (this.limit <= 0) {
                return false;
            }
            this.writer.write(this.buffer, this.offset, this.limit);
            return true;
        }

        @Override
        public int read() throws IOException {
            if (this.offset >= this.limit && !this.fillCache()) {
                return -1;
            }
            return this.buffer[this.offset++];
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int written = 0;
            int bytesAvailable;
            while ((bytesAvailable = this.limit - this.offset) > 0 || this.fillCache()) {
                int bytesToRead = len - off;
                if (bytesToRead == 0) {
                    return written;
                }
                int bytesToWrite = Math.min(bytesAvailable, bytesToRead);
                System.arraycopy(this.buffer, this.offset, b, off, bytesToWrite);
                written += bytesToWrite;
                off += bytesToWrite;
                this.offset += bytesToWrite;
            }
            return written;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public void close() throws IOException {
            boolean finished;
            if (this.closed) {
                return;
            }
            while (finished = this.fillCache()) {
            }
            this.stream.close();
            this.writer.close();
            this.closed = true;
        }
    }

    public class PredictionJJob
    extends BasicJJob<ProbabilityFingerprint> {
        public final Ms2Experiment experiment;
        public final FTree ftree;
        public final IdentificationResult result;
        public final MaskedFingerprintVersion version;
        private final EnumSet<PredictorType> predicors;

        public PredictionJJob(Ms2Experiment experiment, IdentificationResult result, FTree ftree, MaskedFingerprintVersion version, EnumSet<PredictorType> predicors) {
            super(JJob.JobType.WEBSERVICE);
            this.experiment = experiment;
            this.ftree = ftree;
            this.result = result;
            this.version = version;
            this.predicors = predicors;
        }

        public ProbabilityFingerprint compute() throws Exception {
            FingerIdJob job = WebAPI.this.submitJob(this.experiment, this.ftree, this.version, this.predicors);
            new HttpGet(WebAPI.getFingerIdURI("/webapi/job.json").setParameter("jobId", String.valueOf(job.jobId)).setParameter("securityToken", job.securityToken).build());
            for (int k = 0; k < 600; ++k) {
                Thread.sleep(3000 + 30 * k);
                if (WebAPI.this.updateJobStatus(job)) {
                    return job.prediction;
                }
                if (!Objects.equals(job.state, "CRASHED")) continue;
                throw new RuntimeException("Job crashed: " + (job.errorMessage != null ? job.errorMessage : ""));
            }
            throw new TimeoutException("Reached timeout");
        }
    }
}

