/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.storage;

import de.unijena.bioinf.ChemistryBase.properties.PropertyManager;
import de.unijena.bioinf.fingerid.storage.FileFormat;
import java.io.File;
import java.nio.file.Paths;

public class ConfigStorage {
    public static final ConfigStorage CONFIG_STORAGE = new ConfigStorage();
    private File defaultLoadDialogPath = null;
    private File defaultTreeExportPath = null;
    private File defaultSaveFilePath = null;
    private File csvExportPath = null;
    private File defaultCompoundsExportPath = null;
    private FileFormat treeFileFormat = FileFormat.png;
    protected File databaseDirectory;
    private boolean closeNeverAskAgain = false;
    private boolean enforceBio = true;

    public File getCustomDatabaseDirectory() {
        return new File(this.getDatabaseDirectory(), "custom");
    }

    public File getDatabaseDirectory() {
        if (this.databaseDirectory == null) {
            this.databaseDirectory = this.getDefaultDatabaseDirectory();
        }
        return this.databaseDirectory;
    }

    public File getDefaultDatabaseDirectory() {
        String val = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.fingerID.cache");
        return Paths.get(val, new String[0]).toFile();
    }

    public void setDatabaseDirectory(File databaseDirectory) {
        this.databaseDirectory = databaseDirectory;
    }

    public File getCsvExportPath() {
        return this.csvExportPath;
    }

    public void setCsvExportPath(File csvExportPath) {
        this.csvExportPath = csvExportPath;
        this.setAllStoragePaths(csvExportPath);
    }

    public void setDefaultTreeFileFormat(FileFormat fileFormat) {
        this.treeFileFormat = fileFormat;
    }

    public FileFormat getDefaultTreeFileFormat() {
        return this.treeFileFormat;
    }

    public File getDefaultLoadDialogPath() {
        return this.defaultLoadDialogPath;
    }

    public void setDefaultLoadDialogPath(File defaultLoadDialogPath) {
        this.defaultLoadDialogPath = defaultLoadDialogPath;
    }

    public boolean isEnforceBio() {
        return this.enforceBio;
    }

    public void setEnforceBio(boolean enforceBio) {
        this.enforceBio = enforceBio;
    }

    public File getDefaultTreeExportPath() {
        return this.defaultTreeExportPath;
    }

    public File getDefaultCompoundsExportPath() {
        return this.defaultCompoundsExportPath;
    }

    public void setDefaultCompoundsExportPath(File f) {
        this.defaultCompoundsExportPath = f;
        this.setAllStoragePaths(f);
    }

    public void setDefaultTreeExportPath(File defaultTreeExportPath) {
        this.defaultTreeExportPath = defaultTreeExportPath;
        this.setAllStoragePaths(defaultTreeExportPath);
    }

    private void setAllStoragePaths(File path) {
        if (this.defaultTreeExportPath == null) {
            this.defaultTreeExportPath = path;
        }
        if (this.defaultSaveFilePath == null) {
            this.defaultSaveFilePath = path;
        }
        if (this.csvExportPath == null) {
            this.csvExportPath = path;
        }
        if (this.defaultCompoundsExportPath == null) {
            this.defaultCompoundsExportPath = path;
        }
    }

    public File getDefaultSaveFilePath() {
        return this.defaultSaveFilePath;
    }

    public void setDefaultSaveFilePath(File defaultSaveFilePath) {
        this.defaultSaveFilePath = defaultSaveFilePath;
        this.setAllStoragePaths(defaultSaveFilePath);
    }

    public boolean isCloseNeverAskAgain() {
        return this.closeNeverAskAgain;
    }

    public void setCloseNeverAskAgain(boolean closeNeverAskAgain) {
        this.closeNeverAskAgain = closeNeverAskAgain;
    }
}

