/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ms.cli;

import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.HelpRequestedException;
import de.unijena.bioinf.ChemistryBase.chem.FormulaConstraints;
import de.unijena.bioinf.ChemistryBase.chem.Ionization;
import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.chem.PeriodicTable;
import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.jobs.SiriusJobs;
import de.unijena.bioinf.ChemistryBase.ms.Deviation;
import de.unijena.bioinf.ChemistryBase.ms.MeasurementProfile;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Spectrum;
import de.unijena.bioinf.ChemistryBase.ms.MutableMeasurementProfile;
import de.unijena.bioinf.ChemistryBase.ms.MutableMs2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.MutableMs2Spectrum;
import de.unijena.bioinf.ChemistryBase.ms.PossibleAdducts;
import de.unijena.bioinf.ChemistryBase.ms.PossibleIonModes;
import de.unijena.bioinf.ChemistryBase.ms.Spectrum;
import de.unijena.bioinf.ChemistryBase.ms.inputValidators.Warning;
import de.unijena.bioinf.ChemistryBase.ms.utils.SimpleSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.utils.Spectrums;
import de.unijena.bioinf.ChemistryBase.properties.PropertyManager;
import de.unijena.bioinf.FragmentationTreeConstruction.computation.FragmentationPatternAnalysis;
import de.unijena.bioinf.FragmentationTreeConstruction.computation.tree.TreeBuilder;
import de.unijena.bioinf.FragmentationTreeConstruction.computation.tree.TreeBuilderFactory;
import de.unijena.bioinf.IsotopePatternAnalysis.IsotopePattern;
import de.unijena.bioinf.IsotopePatternAnalysis.IsotopePatternAnalysis;
import de.unijena.bioinf.IsotopePatternAnalysis.prediction.DNNRegressionPredictor;
import de.unijena.bioinf.IsotopePatternAnalysis.prediction.ElementPredictor;
import de.unijena.bioinf.babelms.GenericParser;
import de.unijena.bioinf.babelms.MsExperimentParser;
import de.unijena.bioinf.babelms.SpectralParser;
import de.unijena.bioinf.jjobs.BufferedJJobSubmitter;
import de.unijena.bioinf.jjobs.JJob;
import de.unijena.bioinf.jjobs.JobManager;
import de.unijena.bioinf.jjobs.exceptions.TimeoutException;
import de.unijena.bioinf.ms.cli.Instance;
import de.unijena.bioinf.ms.cli.ProjectSpaceMerger;
import de.unijena.bioinf.ms.cli.ShellProgress;
import de.unijena.bioinf.ms.cli.SiriusOptions;
import de.unijena.bioinf.sirius.IdentificationResult;
import de.unijena.bioinf.sirius.Sirius;
import de.unijena.bioinf.sirius.core.ApplicationCore;
import de.unijena.bioinf.sirius.projectspace.DirectoryReader;
import de.unijena.bioinf.sirius.projectspace.DirectoryWriter;
import de.unijena.bioinf.sirius.projectspace.ExperimentResult;
import de.unijena.bioinf.sirius.projectspace.MultipleProjectWriter;
import de.unijena.bioinf.sirius.projectspace.ProjectReader;
import de.unijena.bioinf.sirius.projectspace.ProjectWriter;
import de.unijena.bioinf.sirius.projectspace.SiriusFileReader;
import de.unijena.bioinf.sirius.projectspace.SiriusFileWriter;
import de.unijena.bioinf.sirius.projectspace.SiriusWorkspaceReader;
import de.unijena.bioinf.sirius.projectspace.SiriusWorkspaceWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLI<Options extends SiriusOptions>
extends ApplicationCore {
    protected Sirius sirius;
    protected final boolean shellMode;
    protected ShellProgress progress;
    protected ProjectWriter projectWriter;
    protected boolean shellOutputSurpressed = false;
    protected Logger logger = LoggerFactory.getLogger(CLI.class);
    Options options;
    List<String> inputs;
    List<String> formulas;
    PrecursorIonType[] ionTypes;
    PrecursorIonType[] ionTypesWithoutAdducts;
    protected int instanceIdOffset;
    private static final Pattern CHARGE_PATTERN = Pattern.compile("(\\d+)[+-]?");
    private static final Pattern CHARGE_PATTERN2 = Pattern.compile("[+-]?(\\d+)");
    private static final FormulaConstraints DEFAULT_ELEMENTS = new FormulaConstraints("CHNOP[5]S");

    public static void main(String[] args) {
        try {
            SiriusWorkspaceReader w = new SiriusWorkspaceReader(new File("/home/kaidu/data/datasets/irina_dataset/final.sirius"));
            DirectoryReader reader = new DirectoryReader((DirectoryReader.ReadingEnvironment)w);
            while (reader.hasNext()) {
                ExperimentResult exp = (ExperimentResult)reader.next();
                if (exp.getExperiment() != null) continue;
                System.out.println(exp.getExperimentName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void print(String s) {
        if (!this.shellOutputSurpressed) {
            System.out.print(s);
        }
    }

    public void println(String s) {
        if (!this.shellOutputSurpressed) {
            System.out.println(s);
        }
    }

    protected void printf(String msg, Object ... args) {
        if (!this.shellOutputSurpressed) {
            System.out.printf(Locale.US, msg, args);
        }
    }

    public CLI() {
        this.shellMode = System.console() != null;
        this.progress = new ShellProgress(System.out, this.shellMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute() {
        long time = System.currentTimeMillis();
        try {
            int maxBuffer;
            int initBuffer = this.options.getMinInstanceBuffer() != null ? this.options.getMinInstanceBuffer() : PropertyManager.getNumberOfCores() * 2;
            int n = maxBuffer = this.options.getMaxInstanceBuffer() != null ? this.options.getMaxInstanceBuffer() : initBuffer * 2;
            if (initBuffer <= 0) {
                initBuffer = Integer.MAX_VALUE;
                maxBuffer = 0;
            }
            CLIJobSubmitter submitter = this.newSubmitter(this.handleInput((SiriusOptions)this.options));
            submitter.start(initBuffer, maxBuffer);
        }
        catch (IOException e) {
            this.logger.error("Error while handling the input data", (Throwable)e);
        }
        finally {
            if (this.projectWriter != null) {
                try {
                    this.projectWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.progress.info("Computation time: " + (double)(System.currentTimeMillis() - time) / 1000.0 + "s");
        }
    }

    protected void handleJobs(BufferedJJobSubmitter.JobContainer jc) throws IOException {
        Sirius.SiriusIdentificationJob j = (Sirius.SiriusIdentificationJob)jc.getJob(Sirius.SiriusIdentificationJob.class);
        this.progress.info("Sirius results for: '" + ((Instance)jc.sourceInstance).file.getName() + "', " + ((Instance)jc.sourceInstance).experiment.getName());
        if (j != null) {
            this.handleSiriusResults(jc, j);
        } else {
            this.logger.error("Could not load results for " + ((Instance)jc.sourceInstance).file.getName());
        }
    }

    private void setPrecursorIonTypes(MutableMs2Experiment exp, PossibleAdducts pa, PossibleIonModes.GuessingMode guessingMode, boolean preferProtonation) {
        exp.setAnnotation(PossibleAdducts.class, (Object)pa);
        PossibleIonModes im = (PossibleIonModes)exp.getAnnotation(PossibleIonModes.class, (Object)new PossibleIonModes());
        im.setGuessFromMs1(guessingMode);
        if (preferProtonation) {
            if (guessingMode.isEnabled()) {
                im.enableGuessFromMs1WithCommonIonModes(exp.getPrecursorIonType().getCharge());
            }
            HashSet ionModes = new HashSet(pa.getIonModes());
            for (Ionization ion : ionModes) {
                im.add(ion, 0.02);
            }
            if (exp.getPrecursorIonType().getCharge() > 0) {
                im.add(PrecursorIonType.getPrecursorIonType((String)"[M+H]+").getIonization(), 1.0);
            } else {
                im.add(PrecursorIonType.getPrecursorIonType((String)"[M-H]-").getIonization(), 1.0);
            }
        } else {
            HashSet ionModes = new HashSet(pa.getIonModes());
            for (Ionization ion : ionModes) {
                im.add(ion, 1.0);
            }
        }
        exp.setAnnotation(PossibleIonModes.class, (Object)im);
    }

    protected Sirius.SiriusIdentificationJob makeSiriusJob(Instance i) {
        PossibleIonModes.GuessingMode enabledGuessingMode;
        Sirius.SiriusIdentificationJob job = null;
        this.sirius.setTimeout(i.experiment, this.options.getInstanceTimeout(), this.options.getTreeTimeout());
        List<String> whitelist = this.formulas;
        Set<MolecularFormula> whiteset = this.getFormulaWhiteset(i, whitelist);
        PossibleIonModes.GuessingMode guessingMode = enabledGuessingMode = this.options.isTrustGuessIonFromMS1() ? PossibleIonModes.GuessingMode.SELECT : PossibleIonModes.GuessingMode.ADD_IONS;
        if (this.options.isAutoCharge()) {
            if (i.experiment.getPrecursorIonType().isIonizationUnknown()) {
                i.experiment.setAnnotation(PossibleAdducts.class, null);
                this.setPrecursorIonTypes(i.experiment, new PossibleAdducts((PrecursorIonType[])Iterables.toArray((Iterable)PeriodicTable.getInstance().getKnownLikelyPrecursorIonizations(i.experiment.getPrecursorIonType().getCharge()), PrecursorIonType.class)), enabledGuessingMode, true);
            } else {
                this.setPrecursorIonTypes(i.experiment, new PossibleAdducts(new PrecursorIonType[]{i.experiment.getPrecursorIonType()}), PossibleIonModes.GuessingMode.DISABLED, false);
            }
        } else if (this.options.getIon() != null && this.options.getIon().size() > 1) {
            if (i.experiment.getPrecursorIonType().isIonizationUnknown()) {
                ArrayList<PrecursorIonType> ionTypes = new ArrayList<PrecursorIonType>();
                for (String ion : this.options.getIon()) {
                    ionTypes.add(PrecursorIonType.getPrecursorIonType((String)ion));
                }
                this.setPrecursorIonTypes(i.experiment, new PossibleAdducts(ionTypes), enabledGuessingMode, false);
            } else {
                this.setPrecursorIonTypes(i.experiment, new PossibleAdducts(new PrecursorIonType[]{i.experiment.getPrecursorIonType()}), PossibleIonModes.GuessingMode.DISABLED, false);
            }
        } else if (i.experiment.getPrecursorIonType().isIonizationUnknown()) {
            this.setPrecursorIonTypes(i.experiment, new PossibleAdducts(new PrecursorIonType[]{i.experiment.getPrecursorIonType().getCharge() > 0 ? PrecursorIonType.getPrecursorIonType((String)"[M+H]+") : PrecursorIonType.getPrecursorIonType((String)"[M-H]-")}), enabledGuessingMode, true);
        } else {
            this.setPrecursorIonTypes(i.experiment, new PossibleAdducts(new PrecursorIonType[]{i.experiment.getPrecursorIonType()}), PossibleIonModes.GuessingMode.DISABLED, false);
        }
        if (this.options.isMostIntenseMs2()) {
            this.onlyKeepMostIntenseMS2(i.experiment);
        }
        this.sirius.enableRecalibration(i.experiment, !this.options.isNotRecalibrating());
        this.sirius.setIsotopeMode(i.experiment, this.options.getIsotopes());
        if (whiteset != null) {
            this.sirius.setFormulaSearchList((Ms2Experiment)i.experiment, whiteset);
        }
        job = this.sirius.makeIdentificationJob((Ms2Experiment)i.experiment, this.getNumberOfCandidates().intValue());
        return job;
    }

    protected void onlyKeepMostIntenseMS2(MutableMs2Experiment experiment) {
        if (experiment.getMs2Spectra().size() == 0) {
            return;
        }
        double precursorMass = experiment.getIonMass();
        int mostIntensiveIdx = -1;
        double maxIntensity = -1.0;
        int pos = -1;
        if (experiment.getMs1Spectra().size() == experiment.getMs2Spectra().size()) {
            for (Spectrum spectrum : experiment.getMs1Spectra()) {
                double intensity;
                ++pos;
                Deviation dev = new Deviation(100.0);
                int idx = Spectrums.mostIntensivePeakWithin((Spectrum)spectrum, (double)precursorMass, (Deviation)dev);
                if (idx < 0 || !((intensity = spectrum.getIntensityAt(idx)) > maxIntensity)) continue;
                maxIntensity = intensity;
                mostIntensiveIdx = pos;
            }
        }
        if (mostIntensiveIdx < 0) {
            pos = -1;
            for (Spectrum spectrum : experiment.getMs2Spectra()) {
                ++pos;
                int n = spectrum.size();
                double sumIntensity = 0.0;
                for (int i = 0; i < n; ++i) {
                    sumIntensity += spectrum.getIntensityAt(i);
                }
                if (!(sumIntensity > maxIntensity)) continue;
                maxIntensity = sumIntensity;
                mostIntensiveIdx = pos;
            }
        }
        ArrayList ms1List = new ArrayList();
        ArrayList ms2List = new ArrayList();
        if (experiment.getMs1Spectra().size() == experiment.getMs2Spectra().size()) {
            ms1List.add(experiment.getMs1Spectra().get(mostIntensiveIdx));
        } else {
            ms1List.addAll(experiment.getMs1Spectra());
        }
        ms2List.add(experiment.getMs2Spectra().get(mostIntensiveIdx));
        experiment.setMs1Spectra(ms1List);
        experiment.setMs2Spectra(ms2List);
    }

    protected void handleSiriusResults(BufferedJJobSubmitter.JobContainer jc, Sirius.SiriusIdentificationJob siriusJob) throws IOException {
        if (siriusJob != null) {
            try {
                List results = (List)siriusJob.takeResult();
                if (!results.isEmpty()) {
                    int rank = 1;
                    int n = Math.max(1, (int)Math.ceil(Math.log10(results.size())));
                    for (IdentificationResult result : results) {
                        IsotopePattern pat = (IsotopePattern)result.getRawTree().getAnnotationOrNull(IsotopePattern.class);
                        int isoPeaks = pat == null ? 0 : pat.getPattern().size();
                        this.printf("%" + n + "d.) %s\t%s\tscore: %.2f\ttree: %+.2f\tiso: %.2f\tpeaks: %d\texplained intensity: %.2f %%\tisotope peaks: %d\n", rank++, result.getMolecularFormula().toString(), String.valueOf(result.getResolvedTree().getAnnotationOrNull(PrecursorIonType.class)), result.getScore(), result.getTreeScore(), result.getIsotopeScore(), result.getResolvedTree().numberOfVertices(), this.sirius.getMs2Analyzer().getIntensityRatioOfExplainedPeaks(result.getResolvedTree()) * 100.0, isoPeaks);
                    }
                    if (this.projectWriter != null) {
                        this.projectWriter.writeExperiment(this.createExperimentResult(jc, siriusJob, results));
                    }
                } else {
                    this.logger.warn("Cannot find valid tree that supports the data. You can try to increase the allowed mass deviation with parameter --ppm-max");
                    if (this.projectWriter != null) {
                        this.projectWriter.writeExperiment(new ExperimentResult(siriusJob.getExperiment(), null, "NORESULTS"));
                    }
                }
            }
            catch (TimeoutException e) {
                this.println("Ignore " + siriusJob.getExperiment().getName() + " due to timeout!");
                this.projectWriter.writeExperiment(new ExperimentResult(siriusJob.getExperiment(), null, "TIMEOUT"));
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                this.println("Error during computation of " + siriusJob.getExperiment().getName() + ": " + e.getMessage());
                this.logger.debug("Error during computation of " + siriusJob.getExperiment().getName(), (Throwable)e);
                this.projectWriter.writeExperiment(new ExperimentResult(siriusJob.getExperiment(), null, "ERROR"));
            }
        } else {
            this.logger.debug("Null job occurred!");
        }
    }

    protected ExperimentResult createExperimentResult(BufferedJJobSubmitter.JobContainer jc, Sirius.SiriusIdentificationJob siriusJob, List<IdentificationResult> results) {
        return new ExperimentResult(siriusJob.getExperiment(), results);
    }

    protected Set<MolecularFormula> getFormulaWhiteset(Instance i, List<String> whitelist) {
        HashSet<MolecularFormula> whiteset = new HashSet<MolecularFormula>();
        if (whitelist == null && this.options.getNumberOfCandidates() == null && i.experiment.getMolecularFormula() != null) {
            whiteset.add(i.experiment.getMolecularFormula());
        } else if (whitelist != null) {
            for (String s : whitelist) {
                whiteset.add(MolecularFormula.parse((String)s));
            }
        }
        return whiteset.isEmpty() ? null : whiteset;
    }

    private Integer getNumberOfCandidates() {
        return this.options.getNumberOfCandidates() != null ? this.options.getNumberOfCandidates() : 5;
    }

    protected void cite() {
        this.println("Please cite the following paper when using our method:");
        this.println(ApplicationCore.CITATION);
    }

    protected void parseArgsAndInit(String[] args, Class<Options> optionsClass) {
        this.parseArgs(args, optionsClass);
        this.setup();
        this.validate();
    }

    protected void validate() {
    }

    public void parseArgs(String[] args, Class<Options> optionsClass) {
        if (args.length == 0) {
            this.println(ApplicationCore.VERSION_STRING);
            this.println(CliFactory.createCli(optionsClass).getHelpMessage());
            System.exit(0);
        }
        try {
            args = this.fixBuggyJewelCliLibrary(args);
            this.options = (SiriusOptions)CliFactory.createCli(optionsClass).parseArguments(args);
            if (this.options.isCite()) {
                this.cite();
                System.exit(0);
            }
        }
        catch (HelpRequestedException e) {
            this.println(e.getMessage());
            this.println("");
            this.cite();
            System.exit(0);
        }
        if (this.options.isVersion()) {
            this.println(ApplicationCore.VERSION_STRING);
            this.cite();
            System.exit(0);
        }
        this.handleOutputOptions(this.options);
    }

    private String[] fixBuggyJewelCliLibrary(String[] args) {
        ArrayList<String> argsCopy = new ArrayList<String>();
        ArrayList<String> ionModeStrings = new ArrayList<String>();
        boolean ionIn = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--ion") || arg.equals("-i")) {
                if (!ionIn) {
                    ionModeStrings.add(arg);
                    ionIn = true;
                }
                Pattern ionPattern = Pattern.compile("^\\s*\\[?\\s*M\\s*[+-\\]]");
                ++i;
                while (i < args.length && ionPattern.matcher(arg = args[i]).find()) {
                    ionModeStrings.add(arg);
                    ++i;
                }
            }
            argsCopy.add(arg);
        }
        if (ionModeStrings.size() > 0) {
            ionModeStrings.add("--placeholder");
        }
        ionModeStrings.addAll(argsCopy);
        return ionModeStrings.toArray(new String[ionModeStrings.size()]);
    }

    protected void handleOutputOptions(Options options) {
        ProjectWriter pw;
        int numberOfWrittenExperiments = 0;
        if (options.getNumOfCores() > 0) {
            PropertyManager.PROPERTIES.setProperty("de.unijena.bioinf.sirius.cpu.cores", String.valueOf(options.getNumOfCores()));
        }
        if (options.isQuiet() || "-".equals(options.getSirius())) {
            this.shellOutputSurpressed = true;
            this.disableShellLogging();
        }
        if ("-".equals(options.getOutput())) {
            this.logger.error("Cannot write output files and folders into standard output stream. Please use --sirius t get a zip file of SIRIUS output into the standard output stream");
            System.exit(1);
        }
        ArrayList<ProjectWriter> writers = new ArrayList<ProjectWriter>();
        if (options.getOutput() != null) {
            if (new File(options.getOutput()).exists()) {
                try {
                    this.checkForValidProjectDirectory(options.getOutput());
                    pw = new ProjectSpaceMerger(this, options.getOutput(), false);
                    writers.add(pw);
                    numberOfWrittenExperiments = Math.max(numberOfWrittenExperiments, ((ProjectSpaceMerger)pw).getNumberOfWrittenExperiments());
                }
                catch (IOException e) {
                    this.logger.error("Cannot merge project " + options.getOutput() + ". Maybe the specified directory is not a valid SIRIUS workspace. You can still specify a new not existing filename to create a new workspace.\n" + e.getMessage(), (Throwable)e);
                    System.exit(1);
                    return;
                }
            }
            try {
                pw = this.getDirectoryOutputWriter(options.getOutput(), this.getWorkspaceWritingEnvironmentForDirectoryOutput(options.getOutput()));
                writers.add(pw);
            }
            catch (IOException e) {
                this.logger.error("Cannot write into " + options.getOutput() + ":\n" + e.getMessage(), (Throwable)e);
                System.exit(1);
            }
        }
        if (options.getSirius() != null) {
            if (options.getSirius().equals("-")) {
                pw = this.getSiriusOutputWriter(options.getSirius(), this.getWorkspaceWritingEnvironmentForSirius(options.getSirius()));
                this.shellOutputSurpressed = true;
            } else if (new File(options.getSirius()).exists()) {
                try {
                    pw = new ProjectSpaceMerger(this, options.getSirius(), true);
                    numberOfWrittenExperiments = Math.max(numberOfWrittenExperiments, ((ProjectSpaceMerger)pw).getNumberOfWrittenExperiments());
                }
                catch (IOException e) {
                    System.err.println("Cannot merge " + options.getSirius() + ". The specified file might be no valid SIRIUS workspace. You can still specify a new not existing filename to create a new workspace.");
                    System.exit(1);
                    return;
                }
            } else {
                pw = this.getSiriusOutputWriter(options.getSirius(), this.getWorkspaceWritingEnvironmentForSirius(options.getSirius()));
            }
            writers.add(pw);
        }
        this.projectWriter = writers.size() > 1 ? new MultipleProjectWriter(writers.toArray(new ProjectWriter[writers.size()])) : (writers.size() > 0 ? (ProjectWriter)writers.get(0) : new ProjectWriter(){

            public void writeExperiment(ExperimentResult result) throws IOException {
            }

            public void close() throws IOException {
            }
        });
        this.instanceIdOffset = numberOfWrittenExperiments;
    }

    private void checkForValidProjectDirectory(String output) throws IOException {
        File f = new File(output);
        if (!f.exists()) {
            return;
        }
        if (!f.isDirectory()) {
            throw new IOException("Expect a directory name. But " + output + " is an existing file.");
        }
        Pattern pat = Pattern.compile("Sirius", 2);
        boolean empty = true;
        for (File g : f.listFiles()) {
            empty = false;
            if (!g.getName().equalsIgnoreCase("version.txt")) continue;
            for (String line : Files.readLines((File)g, (Charset)Charset.forName("UTF-8"))) {
                if (!pat.matcher(line).find()) continue;
                return;
            }
        }
        if (!empty) {
            throw new IOException("Given directory is not a valid SIRIUS workspace. Please specify an empty directory or existing SIRIUS workspace!");
        }
    }

    private void disableShellLogging() {
        Handler ch = null;
        for (Handler h : java.util.logging.Logger.getGlobal().getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            ch = h;
            break;
        }
        if (ch != null) {
            java.util.logging.Logger.getGlobal().removeHandler(ch);
        }
    }

    protected DirectoryWriter.WritingEnvironment getWorkspaceWritingEnvironmentForSirius(String value) {
        try {
            if (value.equals("-")) {
                return new SiriusWorkspaceWriter((OutputStream)System.out);
            }
            return new SiriusWorkspaceWriter((OutputStream)new FileOutputStream(new File(value)));
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot write into " + value + ". The given file name might already exists.");
            System.exit(1);
            return null;
        }
    }

    protected DirectoryWriter.WritingEnvironment getWorkspaceWritingEnvironmentForDirectoryOutput(String value) throws IOException {
        File root = new File(value);
        if (root.exists()) {
            System.err.println("Cannot create directory " + root.getName() + ". File already exist.");
            System.exit(1);
            return null;
        }
        root.mkdirs();
        return new SiriusFileWriter(root);
    }

    protected ProjectWriter getSiriusOutputWriter(String sirius, DirectoryWriter.WritingEnvironment env) {
        return new DirectoryWriter(env, ApplicationCore.VERSION_STRING);
    }

    protected ProjectWriter getDirectoryOutputWriter(String sirius, DirectoryWriter.WritingEnvironment env) {
        return new DirectoryWriter(env, ApplicationCore.VERSION_STRING);
    }

    protected DirectoryReader.ReadingEnvironment getWorkspaceReadingEnvironmentForSirius(String value) {
        try {
            return new SiriusWorkspaceReader(new File(value));
        }
        catch (IOException e) {
            System.err.println("Cannot read " + value + ":\n" + e.getMessage());
            System.exit(1);
            return null;
        }
    }

    protected DirectoryReader.ReadingEnvironment getWorkspaceReadingEnvironmentForDirectoryOutput(String value) {
        File root = new File(value);
        return new SiriusFileReader(root);
    }

    protected ProjectReader getSiriusOutputReader(String sirius, DirectoryReader.ReadingEnvironment env) {
        return new DirectoryReader(env);
    }

    protected ProjectReader getDirectoryOutputReader(String sirius, DirectoryReader.ReadingEnvironment env) {
        return new DirectoryReader(env);
    }

    public void setup() {
        try {
            ElementPredictor elementPredictor;
            TreeBuilder builder;
            this.sirius = new Sirius(this.options.getProfile());
            Sirius.USE_FAST_MODE = !this.options.isDisableFastMode();
            FragmentationPatternAnalysis ms2 = this.sirius.getMs2Analyzer();
            IsotopePatternAnalysis ms1 = this.sirius.getMs1Analyzer();
            MutableMeasurementProfile ms1Prof = new MutableMeasurementProfile((MeasurementProfile)ms1.getDefaultProfile());
            MutableMeasurementProfile ms2Prof = new MutableMeasurementProfile((MeasurementProfile)ms2.getDefaultProfile());
            final String outerClassName = this.getClass().getName();
            ms2.setValidatorWarning(new Warning(){

                public void warn(String message) {
                    java.util.logging.Logger.getLogger(outerClassName).warning(message);
                }
            });
            if (this.options.getMedianNoise() != null) {
                ms2Prof.setMedianNoiseIntensity(this.options.getMedianNoise().doubleValue());
            }
            if (this.options.getPPMMax() != null) {
                ms2Prof.setAllowedMassDeviation(new Deviation(this.options.getPPMMax().doubleValue()));
                ms1Prof.setAllowedMassDeviation(new Deviation(this.options.getPPMMax().doubleValue()));
            }
            if ((builder = this.sirius.getMs2Analyzer().getTreeBuilder()) == null) {
                String noILPSolver = "Could not load a valid ILP solver (TreeBuilder) " + Arrays.toString(TreeBuilderFactory.getBuilderPriorities()) + ". Please read the installation instructions.";
                this.logger.error(noILPSolver);
                System.exit(1);
            }
            this.logger.info("Compute trees using " + builder);
            this.sirius.getMs2Analyzer().setDefaultProfile((MeasurementProfile)ms2Prof);
            this.sirius.getMs1Analyzer().setDefaultProfile(ms1Prof);
            if (this.options.isEnableSiliconDetection() && (elementPredictor = this.sirius.getElementPrediction()) instanceof DNNRegressionPredictor) {
                ((DNNRegressionPredictor)elementPredictor).enableSilicon();
            }
        }
        catch (IOException e) {
            this.logger.error("Cannot load profile '" + this.options.getProfile() + "':\n", (Throwable)e);
            System.exit(1);
        }
    }

    protected Instance setupInstance(Instance inst) {
        MutableMs2Experiment exp;
        MutableMs2Experiment mutableMs2Experiment = exp = inst.experiment instanceof MutableMs2Experiment ? inst.experiment : new MutableMs2Experiment((Ms2Experiment)inst.experiment);
        if (exp.getPrecursorIonType() == null || exp.getPrecursorIonType().isIonizationUnknown()) {
            exp.setPrecursorIonType(CLI.getIonFromOptions(this.options, exp.getPrecursorIonType() == null ? 0 : exp.getPrecursorIonType().getCharge()));
        }
        if (this.formulas != null && this.formulas.size() == 1) {
            exp.setMolecularFormula(MolecularFormula.parse((String)this.formulas.get(0)));
        }
        if (this.options.getParentMz() != null) {
            exp.setIonMass(this.options.getParentMz().doubleValue());
        }
        return new Instance((Ms2Experiment)exp, inst.file, inst.index);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Iterator<Instance> handleInput(final SiriusOptions options) throws IOException {
        FormulaConstraints constraints;
        final ArrayDeque<Instance> instances = new ArrayDeque<Instance>();
        this.inputs = options.getInput() == null ? new ArrayList() : options.getInput();
        this.formulas = options.getFormula();
        if (this.formulas != null) {
            String s;
            this.formulas = new ArrayList<String>(this.formulas);
            ListIterator<String> iter = this.formulas.listIterator(this.formulas.size());
            while (iter.hasPrevious() && new File(s = iter.previous()).exists()) {
                this.inputs.add(s);
                iter.remove();
            }
        }
        final MsExperimentParser parser = new MsExperimentParser();
        Double defaultParentMass = options.getParentMz();
        FormulaConstraints formulaConstraints = constraints = options.getElements() == null ? null : options.getElements();
        if (options.getMs2() != null && !options.getMs2().isEmpty()) {
            double expPrecursor;
            Iterator spiter;
            MutableMeasurementProfile profile = new MutableMeasurementProfile();
            profile.setFormulaConstraints(constraints);
            MutableMs2Experiment exp = new MutableMs2Experiment();
            exp.setSource(options.getMs2().get(0));
            PrecursorIonType ionType = CLI.getIonFromOptions(options, 0);
            exp.setPrecursorIonType(ionType);
            exp.setMs2Spectra(new ArrayList());
            for (File f : this.foreachIn(options.getMs2())) {
                spiter = SpectralParser.getParserFor((File)f).parseSpectra(f);
                while (spiter.hasNext()) {
                    Ms2Spectrum spec = (Ms2Spectrum)spiter.next();
                    if (spec.getIonization() == null || spec.getPrecursorMz() == 0.0 || spec.getMsLevel() == 0) {
                        MutableMs2Spectrum ms = spec instanceof MutableMs2Spectrum ? (MutableMs2Spectrum)spec : new MutableMs2Spectrum((Spectrum)spec);
                        if (ms.getIonization() == null) {
                            ms.setIonization(ionType.getIonization());
                        }
                        if (ms.getMsLevel() == 0) {
                            ms.setMsLevel(2);
                        }
                        if (ms.getPrecursorMz() == 0.0) {
                            if (defaultParentMass == null) {
                                if (exp.getMs2Spectra().size() > 0) {
                                    ms.setPrecursorMz(((MutableMs2Spectrum)exp.getMs2Spectra().get(0)).getPrecursorMz());
                                } else {
                                    void var14_21;
                                    if (exp.getMolecularFormula() != null) {
                                        MolecularFormula molecularFormula = exp.getMolecularFormula();
                                    } else if (this.formulas != null && this.formulas.size() == 1) {
                                        MolecularFormula molecularFormula = MolecularFormula.parse((String)this.formulas.get(0));
                                    } else {
                                        Object var14_24 = null;
                                    }
                                    if (var14_21 != null) {
                                        ms.setPrecursorMz(ms.getIonization().addToMass(var14_21.getMass()));
                                    } else {
                                        ms.setPrecursorMz(0.0);
                                    }
                                }
                            } else {
                                ms.setPrecursorMz(defaultParentMass.doubleValue());
                            }
                        }
                    }
                    exp.getMs2Spectra().add(new MutableMs2Spectrum((Spectrum)spec));
                }
            }
            if (exp.getMs2Spectra().size() <= 0) {
                throw new IllegalArgumentException("SIRIUS expect at least one MS/MS spectrum. Please add a MS/MS spectrum via --ms2 option");
            }
            if (options.getMs2() != null && options.getMs1() != null && !options.getMs1().isEmpty()) {
                exp.setMs1Spectra(new ArrayList());
                for (File f : options.getMs1()) {
                    spiter = SpectralParser.getParserFor((File)f).parseSpectra(f);
                    while (spiter.hasNext()) {
                        exp.getMs1Spectra().add(new SimpleSpectrum((Spectrum)spiter.next()));
                    }
                }
                exp.setMergedMs1Spectrum((SimpleSpectrum)exp.getMs1Spectra().get(0));
            }
            if (options.getParentMz() != null) {
                expPrecursor = options.getParentMz();
            } else if (exp.getMolecularFormula() != null) {
                expPrecursor = exp.getPrecursorIonType().neutralMassToPrecursorMass(exp.getMolecularFormula().getMass());
            } else {
                double prec = 0.0;
                for (int k = 1; k < exp.getMs2Spectra().size(); ++k) {
                    double d = ((MutableMs2Spectrum)exp.getMs2Spectra().get(k)).getPrecursorMz();
                    if (d != 0.0 && Math.abs(d - ((MutableMs2Spectrum)exp.getMs2Spectra().get(0)).getPrecursorMz()) > 0.001) {
                        throw new IllegalArgumentException("The given MS/MS spectra have different precursor mass and cannot belong to the same compound");
                    }
                    if (d == 0.0) continue;
                    prec = d;
                }
                if (prec == 0.0) {
                    if (exp.getMs1Spectra().size() <= 0) throw new IllegalArgumentException("SIRIUS expects the parentmass of the measured compound as parameter. Please provide it via the -z option.");
                    SimpleSpectrum patterns = this.sirius.getMs1Analyzer().extractPattern((Ms2Experiment)exp, exp.getMergedMs1Spectrum().getMzAt(0));
                    if (patterns.size() < exp.getMergedMs1Spectrum().size()) {
                        throw new IllegalArgumentException("SIRIUS cannot infer the parentmass of the measured compound from MS1 spectrum. Please provide it via the -z option.");
                    }
                    expPrecursor = patterns.getMzAt(0);
                } else {
                    expPrecursor = prec;
                }
            }
            exp.setIonMass(expPrecursor);
            if (exp.getName() == null) {
                exp.setName("unknown");
            }
            if (constraints != null) {
                this.sirius.setFormulaConstraints((Ms2Experiment)exp, constraints);
            }
            if (options.isDisableElementDetection()) {
                this.sirius.enableAutomaticElementDetection((Ms2Experiment)exp, false);
            }
            instances.add(new Instance((Ms2Experiment)exp, options.getMs2().get(0), ++this.instanceIdOffset));
        } else if (options.getMs1() != null && !options.getMs1().isEmpty()) {
            throw new IllegalArgumentException("SIRIUS expect at least one MS/MS spectrum. Please add a MS/MS spectrum via --ms2 option");
        }
        if (this.inputs.isEmpty()) return instances.iterator();
        ArrayList<File> infiles = new ArrayList<File>();
        Collections.sort(this.inputs);
        for (String f : this.inputs) {
            File g = new File(f);
            if (g.isDirectory()) {
                File[] ins = g.listFiles(pathname -> pathname.isFile());
                if (ins == null) continue;
                Arrays.sort(ins, Comparator.comparing(File::getName));
                infiles.addAll(Arrays.asList(ins));
                continue;
            }
            infiles.add(g);
        }
        final Iterator fileIter = infiles.iterator();
        return new Iterator<Instance>(){
            File currentFile;
            int index;
            Iterator<Ms2Experiment> experimentIterator;
            {
                this.index = CLI.this.instanceIdOffset;
                this.experimentIterator = this.fetchNext();
            }

            @Override
            public boolean hasNext() {
                return !instances.isEmpty();
            }

            @Override
            public Instance next() {
                this.fetchNext();
                Instance c = (Instance)instances.poll();
                return CLI.this.setupInstance(c);
            }

            private Iterator<Ms2Experiment> fetchNext() {
                MutableMs2Experiment experiment;
                while (true) {
                    if (this.experimentIterator == null || !this.experimentIterator.hasNext()) {
                        if (fileIter.hasNext()) {
                            this.currentFile = (File)fileIter.next();
                            try {
                                GenericParser p = parser.getParser(this.currentFile);
                                if (p == null) {
                                    CLI.this.logger.error("Unknown file format: '" + this.currentFile + "'");
                                    continue;
                                }
                                this.experimentIterator = p.parseFromFileIterator(this.currentFile);
                            }
                            catch (IOException e) {
                                CLI.this.logger.error("Cannot parse file '" + this.currentFile + "':\n", (Throwable)e);
                            }
                            continue;
                        }
                        return null;
                    }
                    experiment = CLI.this.sirius.makeMutable(this.experimentIterator.next());
                    if (options.getMaxMz() == null || !(experiment.getIonMass() > options.getMaxMz())) break;
                }
                if (constraints != null) {
                    CLI.this.sirius.setFormulaConstraints((Ms2Experiment)experiment, constraints);
                }
                if (options.isDisableElementDetection()) {
                    CLI.this.sirius.enableAutomaticElementDetection((Ms2Experiment)experiment, false);
                }
                instances.add(new Instance((Ms2Experiment)experiment, this.currentFile, ++this.index));
                return this.experimentIterator;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private List<File> foreachIn(List<File> ms2) {
        ArrayList<File> queue = new ArrayList<File>();
        for (File f : ms2) {
            if (f.isDirectory()) {
                for (File g : f.listFiles()) {
                    if (g.isDirectory()) continue;
                    queue.add(g);
                }
                continue;
            }
            queue.add(f);
        }
        return queue;
    }

    protected static PrecursorIonType getIonFromOptions(SiriusOptions opt, int charge) {
        List<String> ionStr = opt.getIon();
        if (ionStr == null) {
            return PrecursorIonType.unknown((int)charge);
        }
        if (ionStr.size() == 1) {
            PrecursorIonType ionType = PeriodicTable.getInstance().ionByName(opt.getIon().get(0));
            if (ionType.isIonizationUnknown() && !opt.isAutoCharge()) {
                if (ionType.getCharge() > 0) {
                    return PrecursorIonType.getPrecursorIonType((String)"[M+H]+");
                }
                return PrecursorIonType.getPrecursorIonType((String)"[M-H]-");
            }
            return ionType;
        }
        ArrayList<PrecursorIonType> ionTypes = new ArrayList<PrecursorIonType>();
        for (String ion : ionStr) {
            ionTypes.add(PrecursorIonType.getPrecursorIonType((String)ion));
        }
        int ch = ((PrecursorIonType)ionTypes.get(0)).getCharge();
        for (PrecursorIonType pi : ionTypes) {
            if (pi.getCharge() == ch) continue;
            throw new IllegalArgumentException("SIRIUS does not support different charge states for the same compound");
        }
        return PrecursorIonType.unknown((int)ch);
    }

    public FormulaConstraints getDefaultElementSet(SiriusOptions opts) {
        FormulaConstraints cf = opts.getElements() != null ? opts.getElements() : DEFAULT_ELEMENTS;
        return cf;
    }

    protected static String fileNameWithoutExtension(File file) {
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i >= 0) {
            return name.substring(0, i);
        }
        return name;
    }

    private <T> boolean arrayContains(T[] array, T object) {
        return this.arrayFind(array, object) >= 0;
    }

    private <T> int arrayFind(T[] array, T object) {
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            if (!t.equals(object)) continue;
            return i;
        }
        return -1;
    }

    private int countMatches(String string, String sub) {
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = string.indexOf(sub, lastIndex)) == -1) continue;
            ++count;
            lastIndex += sub.length();
        }
        return count;
    }

    protected CLIJobSubmitter newSubmitter(Iterator<Instance> instanceIterator) {
        return new CLIJobSubmitter(instanceIterator);
    }

    protected class CLIJobSubmitter
    extends BufferedJJobSubmitter<Instance> {
        public CLIJobSubmitter(Iterator<Instance> instances) {
            super(instances);
        }

        protected void submitJobs(BufferedJJobSubmitter.JobContainer watcher) {
            this.submitJob((JJob)CLI.this.makeSiriusJob((Instance)watcher.sourceInstance), watcher);
        }

        protected void handleResults(BufferedJJobSubmitter.JobContainer watcher) {
            try {
                CLI.this.handleJobs(watcher);
            }
            catch (IOException e) {
                CLI.this.logger.error("Error processing instance: " + ((Instance)watcher.sourceInstance).file.getName());
            }
        }

        protected JobManager jobManager() {
            return SiriusJobs.getGlobalJobManager();
        }
    }
}

