/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ms.cli;

import com.lexicalscope.jewel.cli.Option;
import de.unijena.bioinf.fingeriddb.job.UserDefineablePredictorType;
import de.unijena.bioinf.ms.cli.SiriusOptions;
import java.io.File;
import java.util.List;

public interface FingerIdOptions
extends SiriusOptions {
    @Option(shortName={"d"}, defaultValue={"all"}, description="search formulas in given database: all, pubchem, bio, kegg, hmdb")
    public String getDatabase();

    @Option(longName={"fingerid-db", "fingerid_db"}, description="search structure in given database. By default the same database for molecular formula search is also used for structure search. If no database is used for molecular formula search, PubChem is used for structure search. Accepts also a filepath to a valid database directory.", defaultToNull=true)
    public String getFingerIdDb();

    @Option(shortName={"F"}, description="search structure with CSI:FingerID")
    public boolean isFingerid();

    @Option(longName={"fingerid-predictors"}, shortName={"P"}, description="Predictors used to search structure with CSI:FingerID", defaultValue={"CSI_FINGERID"})
    public List<UserDefineablePredictorType> getPredictors();

    @Option(longName={"generate-custom-db"}, description="EXPERIMENTAL FEATURE: generate a custom compound database. Ignore all other options. Import compounds from all given files. Usage: sirius --generate-custom-db [DATABASENAME] [INPUTFILE1] [INPUTFILE2] ... ", defaultToNull=true)
    public String getGeneratingCompoundDatabase();

    @Option(longName={"experimental-canopus"}, hidden=true, defaultToNull=true)
    public File getExperimentalCanopus();
}

