/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ms.cli;

import com.google.common.base.Joiner;
import de.unijena.bioinf.ChemistryBase.algorithm.Scored;
import de.unijena.bioinf.ChemistryBase.chem.CompoundWithAbstractFP;
import de.unijena.bioinf.ChemistryBase.chem.FormulaConstraints;
import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.fp.AbstractFingerprint;
import de.unijena.bioinf.ChemistryBase.fp.ClassyFireFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.ClassyfireProperty;
import de.unijena.bioinf.ChemistryBase.fp.MaskedFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.ms.Deviation;
import de.unijena.bioinf.ChemistryBase.ms.PossibleAdducts;
import de.unijena.bioinf.ChemistryBase.utils.FileUtils;
import de.unijena.bioinf.canopus.Canopus;
import de.unijena.bioinf.chemdb.BioFilter;
import de.unijena.bioinf.chemdb.CompoundCandidate;
import de.unijena.bioinf.chemdb.DatasourceService;
import de.unijena.bioinf.chemdb.FilebasedDatabase;
import de.unijena.bioinf.chemdb.FingerprintCandidate;
import de.unijena.bioinf.chemdb.FormulaCandidate;
import de.unijena.bioinf.chemdb.RESTDatabase;
import de.unijena.bioinf.fingerid.CSIPredictor;
import de.unijena.bioinf.fingerid.FingerIdResult;
import de.unijena.bioinf.fingerid.FingerIdResultReader;
import de.unijena.bioinf.fingerid.FingerIdResultWriter;
import de.unijena.bioinf.fingerid.db.CustomDatabase;
import de.unijena.bioinf.fingerid.db.DatabaseImporter;
import de.unijena.bioinf.fingerid.db.SearchableDatabase;
import de.unijena.bioinf.fingerid.db.SearchableDbOnDisc;
import de.unijena.bioinf.fingerid.jjobs.FingerIDJJob;
import de.unijena.bioinf.fingerid.net.WebAPI;
import de.unijena.bioinf.fingerid.storage.ConfigStorage;
import de.unijena.bioinf.fingeriddb.job.PredictorType;
import de.unijena.bioinf.jjobs.BasicJJob;
import de.unijena.bioinf.jjobs.BufferedJJobSubmitter;
import de.unijena.bioinf.jjobs.JJob;
import de.unijena.bioinf.ms.cli.CLI;
import de.unijena.bioinf.ms.cli.FingerIdOptions;
import de.unijena.bioinf.ms.cli.Instance;
import de.unijena.bioinf.sirius.IdentificationResult;
import de.unijena.bioinf.sirius.Sirius;
import de.unijena.bioinf.sirius.projectspace.DirectoryReader;
import de.unijena.bioinf.sirius.projectspace.DirectoryWriter;
import de.unijena.bioinf.sirius.projectspace.ExperimentResult;
import de.unijena.bioinf.sirius.projectspace.ProjectReader;
import de.unijena.bioinf.sirius.projectspace.ProjectWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.slf4j.LoggerFactory;

public class FingeridCLI<Options extends FingerIdOptions>
extends CLI<Options> {
    protected CSIPredictor positivePredictor;
    protected CSIPredictor negativePredictor;
    SearchableDatabase pubchemDatabase;
    SearchableDatabase bioDatabase;
    HashMap<File, FilebasedDatabase> customDatabaseCache;
    private HashMap<String, SearchableDatabase> customDatabases;
    protected File db_cache_dir;
    protected Canopus canopus = null;
    protected static final String CONSIDER_ALL_FORMULAS = "all";

    @Override
    protected ProjectWriter getSiriusOutputWriter(String sirius, DirectoryWriter.WritingEnvironment env) {
        return new FingerIdResultWriter(env);
    }

    @Override
    protected ProjectWriter getDirectoryOutputWriter(String sirius, DirectoryWriter.WritingEnvironment env) {
        return new FingerIdResultWriter(env);
    }

    @Override
    protected ProjectReader getSiriusOutputReader(String sirius, DirectoryReader.ReadingEnvironment env) {
        return new FingerIdResultReader(env);
    }

    @Override
    protected ProjectReader getDirectoryOutputReader(String sirius, DirectoryReader.ReadingEnvironment env) {
        return new FingerIdResultReader(env);
    }

    @Override
    protected void parseArgsAndInit(String[] args, Class<Options> optionsClass) {
        CustomDatabase.customDatabases(true);
        super.parseArgsAndInit(args, optionsClass);
        this.initDatabasesAndVersionInfoIfNecessary();
        if (((FingerIdOptions)this.options).getGeneratingCompoundDatabase() != null) {
            try {
                this.generateCustomDatabase((FingerIdOptions)this.options);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
            return;
        }
        if (((FingerIdOptions)this.options).isFingerid()) {
            this.initFingerBlast();
            this.initCanopus();
        }
    }

    private void initDatabasesAndVersionInfoIfNecessary() {
        if (this.isOffline()) {
            return;
        }
        try {
            this.positivePredictor = new CSIPredictor(PredictorType.CSI_FINGERID_POSITIVE);
            this.negativePredictor = new CSIPredictor(PredictorType.CSI_FINGERID_NEGATIVE);
            this.positivePredictor.initialize();
            this.negativePredictor.initialize();
        }
        catch (IOException e) {
            System.err.println("Cannot connect to CSI:FingerID webserver and online chemical database. You can still use SIRIUS in offline mode: just do not use any chemical database and omit the --fingerid option.");
            LoggerFactory.getLogger(FingeridCLI.class).error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    protected void handleJobs(BufferedJJobSubmitter.JobContainer jc) throws IOException {
        super.handleJobs(jc);
        if (((FingerIdOptions)this.options).isFingerid()) {
            this.progress.info("CSI:FingerID results for: '" + ((Instance)jc.sourceInstance).file.getName() + "'");
            FingerIDJJob fij = (FingerIDJJob)jc.getJob(FingerIDJJob.class);
            if (fij != null) {
                this.handleFingerIdResults((Instance)jc.sourceInstance, fij);
            }
        }
    }

    private void generateCustomDatabase(FingerIdOptions options) throws IOException {
        DatabaseImporter.importDatabase(options.getGeneratingCompoundDatabase(), options.getInput());
    }

    protected FingerIDJJob makeFingerIdJob(Instance i, BasicJJob<List<IdentificationResult>> siriusJob) {
        if (siriusJob == null) {
            return null;
        }
        HashMap<String, Long> dbMap = this.getDatabaseAliasMap();
        Long flagW = dbMap.get(((FingerIdOptions)this.options).getDatabase());
        if (flagW == null) {
            flagW = 0L;
        }
        long flag = flagW;
        CSIPredictor csi = i.experiment.getPrecursorIonType().getCharge() > 0 ? this.positivePredictor : this.negativePredictor;
        FingerIDJJob fingerIdJob = new FingerIDJJob(csi.getBlaster(), csi.getFingerprintVersion(), csi.getDatabase(), this.getFingerIdDatabase(), ((FingerIdOptions)this.options).getPredictors());
        fingerIdJob.addRequiredJob((JJob)siriusJob);
        fingerIdJob.setDbFlag(flag);
        fingerIdJob.setBioFilter(this.getBioFilter());
        fingerIdJob.setCanopus(this.canopus);
        return fingerIdJob;
    }

    public boolean isOffline() {
        return !((FingerIdOptions)this.options).isFingerid() && ((FingerIdOptions)this.options).getDatabase().equals(CONSIDER_ALL_FORMULAS);
    }

    @Override
    protected ExperimentResult createExperimentResult(BufferedJJobSubmitter.JobContainer jc, Sirius.SiriusIdentificationJob siriusJob, List<IdentificationResult> results) {
        FingerIDJJob fid = (FingerIDJJob)jc.getJob(FingerIDJJob.class);
        ArrayList<IdentificationResult> total = new ArrayList<IdentificationResult>(results);
        if (fid != null) {
            fid.takeResult();
            total.addAll(fid.getAddedIdentificationResults());
        }
        return new ExperimentResult(siriusJob.getExperiment(), total);
    }

    /*
     * WARNING - void declaration
     */
    protected void handleFingerIdResults(Instance i, FingerIDJJob fingerprintJob) {
        try {
            Map propPrints = (Map)fingerprintJob.awaitResult();
            if (propPrints != null) {
                void var9_15;
                ArrayList<CandidateElement> allCandidates = new ArrayList<CandidateElement>();
                for (IdentificationResult identificationResult : propPrints.keySet()) {
                    FingerIdResult fingerIdResult = (FingerIdResult)identificationResult.getAnnotationOrNull(FingerIdResult.class);
                    if (fingerIdResult == null) continue;
                    for (Scored<FingerprintCandidate> scored : fingerIdResult.getCandidates()) {
                        allCandidates.add(new CandidateElement(fingerIdResult, scored));
                    }
                }
                allCandidates.sort(Scored.desc());
                if (allCandidates.size() == 0) {
                    this.progress.info("No candidate structures found for given mass and computed trees.");
                    return;
                }
                FingerIdResult topResult = ((CandidateElement)((Object)allCandidates.get((int)0))).origin;
                ArrayList<Scored> confidenceList = new ArrayList<Scored>();
                ArrayList<Scored> bioConfidenceList = new ArrayList<Scored>();
                CandidateElement topBio = null;
                for (CandidateElement fc : allCandidates) {
                    Scored c = new Scored((Object)new CompoundWithAbstractFP(((FingerprintCandidate)fc.getCandidate()).getInchi(), (AbstractFingerprint)((FingerprintCandidate)fc.getCandidate()).getFingerprint()), fc.getScore());
                    confidenceList.add(c);
                    if (!DatasourceService.isBio((long)((FingerprintCandidate)fc.getCandidate()).getBitset())) continue;
                    bioConfidenceList.add(c);
                    if (topBio != null) continue;
                    topBio = fc;
                }
                if (this.getBioFilter() != BioFilter.ONLY_BIO && topBio != null && topBio.getCandidate() != ((CandidateElement)((Object)allCandidates.get(0))).getCandidate()) {
                    CandidateElement fc;
                    Scored scored = (Scored)bioConfidenceList.get(0);
                    fc = (CompoundCandidate)topBio.getCandidate();
                    CompoundWithAbstractFP[] list = new CompoundWithAbstractFP[bioConfidenceList.size()];
                    for (int k = 0; k < bioConfidenceList.size(); ++k) {
                        list[k] = (CompoundWithAbstractFP)((Scored)bioConfidenceList.get(k)).getCandidate();
                    }
                    String name = fc.getName();
                    if (name == null || name.isEmpty()) {
                        name = fc.getSmiles();
                    }
                    if (name == null || name.isEmpty()) {
                        name = "";
                    }
                    this.progress.info(String.format(Locale.US, "Top biocompound is %s %s (%s)\n", name, topBio.origin.getPrecursorIonType().toString(), fc.getInchi().in2D));
                }
                boolean bl = false;
                while (var9_15 < Math.min(20, allCandidates.size())) {
                    CandidateElement e = (CandidateElement)((Object)allCandidates.get((int)var9_15));
                    FingerprintCandidate f = (FingerprintCandidate)e.getCandidate();
                    String n = f.getName();
                    if (n == null || n.isEmpty()) {
                        n = f.getSmiles();
                    }
                    if (n == null) {
                        n = "";
                    }
                    this.println(String.format(Locale.US, "%2d.) %s\t%s\t%s\t%s\tscore: %.2f", (int)(var9_15 + true), n, e.origin.getResolvedTree().getRoot().getFormula().toString(), e.origin.getPrecursorIonType().toString(), f.getInchi().in2D, ((CandidateElement)((Object)allCandidates.get((int)var9_15))).getScore()));
                    ++var9_15;
                }
                if (allCandidates.size() > 20) {
                    this.println("... " + (allCandidates.size() - 20) + " further candidates.");
                }
                this.println("");
            }
        }
        catch (ExecutionException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error while searching structure for " + i.experiment.getName() + " (" + i.file + "): " + e.getMessage(), (Throwable)e);
        }
    }

    private BioFilter getBioFilter(String option) {
        BioFilter bioFilter = option.equalsIgnoreCase("pubchem") || option.equalsIgnoreCase(CONSIDER_ALL_FORMULAS) ? BioFilter.ALL : BioFilter.ONLY_BIO;
        return bioFilter;
    }

    private BioFilter getBioFilter() {
        BioFilter bioFilter = ((FingerIdOptions)this.options).getDatabase().equalsIgnoreCase("pubchem") || ((FingerIdOptions)this.options).getDatabase().equalsIgnoreCase(CONSIDER_ALL_FORMULAS) ? BioFilter.ALL : BioFilter.ONLY_BIO;
        return bioFilter;
    }

    @Override
    public void validate() {
        super.validate();
        if (((FingerIdOptions)this.options).getFingerIdDb() != null && !((FingerIdOptions)this.options).isFingerid()) {
            LoggerFactory.getLogger(this.getClass()).error("--fingerid_db defines the database CSI:FingerID should search in. This option makes only sense when used together with --fingerid. Use --db for setting up the database in which SIRIUS should search for molecular formulas.");
            System.exit(1);
        }
        if (((FingerIdOptions)this.options).getExperimentalCanopus() != null && !((FingerIdOptions)this.options).isFingerid()) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot predict compound categories with CSI:FingerID is disabled. Please enable CSI:FingerID with --fingerid option.");
            System.exit(1);
        }
    }

    private SearchableDatabase getDatabase() {
        return this.getDatabase(((FingerIdOptions)this.options).getDatabase());
    }

    private SearchableDatabase getDatabase(String name) {
        HashMap<String, Long> aliasMap = this.getDatabaseAliasMap();
        if (!aliasMap.containsKey(name.toLowerCase())) {
            if (new File(name).exists()) {
                try {
                    CustomDatabase db = new CustomDatabase(new File(name).getName(), new File(name));
                    db.readSettings();
                    if (db.needsUpgrade()) {
                        System.err.println("Database '" + name + "' is outdated and have to be upgraded or reimported.");
                        System.exit(1);
                    }
                    return db;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.customDatabases.containsKey(name)) {
                return this.customDatabases.get(name);
            }
            this.unknownDatabaseError(name, aliasMap);
            return null;
        }
        if (this.customDatabases.containsKey(name)) {
            return this.customDatabases.get(name);
        }
        BioFilter filter = this.getBioFilter(name);
        if (filter == BioFilter.ALL) {
            return this.pubchemDatabase;
        }
        return this.bioDatabase;
    }

    protected void initializeDatabaseCache() {
        File d;
        this.db_cache_dir = d = ConfigStorage.CONFIG_STORAGE.getDatabaseDirectory();
        this.pubchemDatabase = new SearchableDbOnDisc("PubChem", d, true, true, false);
        this.bioDatabase = new SearchableDbOnDisc("biological database", d, true, true, false);
        this.customDatabaseCache = new HashMap();
        this.customDatabases = new HashMap();
        for (SearchableDatabase searchableDatabase : CustomDatabase.customDatabases(true)) {
            this.customDatabases.put(searchableDatabase.name(), searchableDatabase);
        }
    }

    protected FilebasedDatabase getFileBasedDb(SearchableDatabase db) throws IOException {
        if (!this.customDatabaseCache.containsKey(db.getDatabasePath())) {
            this.customDatabaseCache.put(db.getDatabasePath(), new FilebasedDatabase(WebAPI.getFingerprintVersion(), db.getDatabasePath()));
        }
        return this.customDatabaseCache.get(db.getDatabasePath());
    }

    private SearchableDatabase getFingerIdDatabase() {
        return this.getDatabase(this.getFingerIdDatabaseOption());
    }

    private String getFingerIdDatabaseOption() {
        if (((FingerIdOptions)this.options).getFingerIdDb() != null) {
            return ((FingerIdOptions)this.options).getFingerIdDb();
        }
        return ((FingerIdOptions)this.options).getDatabase();
    }

    private void initFingerBlast() {
    }

    public void initCanopus() {
        if (((FingerIdOptions)this.options).getExperimentalCanopus() != null) {
            try {
                this.canopus = Canopus.loadFromFile((File)((FingerIdOptions)this.options).getExperimentalCanopus());
                try (BufferedWriter bw = FileUtils.getWriter((File)new File("canopus.csv"));){
                    bw.write("relativeIndex\tabsoluteIndex\tid\tname\tdescription\n");
                    ClassyFireFingerprintVersion cv = this.canopus.getClassyFireFingerprintVersion();
                    MaskedFingerprintVersion mask = this.canopus.getCanopusMask();
                    int k = 0;
                    for (int index : mask.allowedIndizes()) {
                        ClassyfireProperty prop = cv.getMolecularProperty(index);
                        bw.write(String.format(Locale.US, "%d\t%d\t%s\t%s\t%s\n", k++, index, prop.getChemontIdentifier(), prop.getName(), prop.getDescription()));
                    }
                }
            }
            catch (IOException e) {
                System.err.println("Cannot load given canopus model: " + e.getMessage());
            }
        }
    }

    private <T extends Collection<FingerprintCandidate>> T filterByFlag(T fingerprintCandidates, String fingerIdDatabaseOption) {
        String dbOptName;
        HashMap<String, Long> aliasMap = this.getDatabaseAliasMap();
        long flag = aliasMap.containsKey(dbOptName = fingerIdDatabaseOption.toLowerCase()) ? (aliasMap.get(dbOptName) == DatasourceService.Sources.BIO.flag ? 0L : aliasMap.get(dbOptName)) : 0L;
        if (flag == 0L) {
            return fingerprintCandidates;
        }
        ArrayList<FingerprintCandidate> filtered = new ArrayList<FingerprintCandidate>();
        for (FingerprintCandidate fc : fingerprintCandidates) {
            if ((flag & fc.getBitset()) == 0L) continue;
            filtered.add(fc);
        }
        fingerprintCandidates.clear();
        fingerprintCandidates.addAll(filtered);
        return fingerprintCandidates;
    }

    @Override
    protected Set<MolecularFormula> getFormulaWhiteset(Instance i, List<String> whitelist) {
        String dbOptName = ((FingerIdOptions)this.options).getDatabase().toLowerCase();
        if (dbOptName.equals(CONSIDER_ALL_FORMULAS)) {
            return super.getFormulaWhiteset(i, whitelist);
        }
        HashMap<String, Long> aliasMap = this.getDatabaseAliasMap();
        SearchableDatabase searchableDatabase = this.getDatabase();
        long flag = aliasMap.containsKey(dbOptName) ? (aliasMap.get(dbOptName) == DatasourceService.Sources.BIO.flag ? 0L : aliasMap.get(dbOptName)) : 0L;
        Deviation dev = ((FingerIdOptions)this.options).getPPMMax() != null ? new Deviation(((FingerIdOptions)this.options).getPPMMax().doubleValue()) : this.sirius.getMs2Analyzer().getDefaultProfile().getAllowedMassDeviation();
        HashSet<PrecursorIonType> allowedIonTypes = new HashSet<PrecursorIonType>();
        if (i.experiment.getPrecursorIonType() == null || i.experiment.getPrecursorIonType().isIonizationUnknown()) {
            allowedIonTypes.addAll(((PossibleAdducts)i.experiment.getAnnotation(PossibleAdducts.class)).getAdducts());
        } else {
            allowedIonTypes.add(i.experiment.getPrecursorIonType());
        }
        FormulaConstraints allowedAlphabet = ((FingerIdOptions)this.options).getElements() != null ? ((FingerIdOptions)this.options).getElements() : new FormulaConstraints("CHNOPSBBrClIF");
        ArrayList candidates = new ArrayList();
        try {
            WebAPI api = WebAPI.newInstance();
            Object object = null;
            try {
                Object object2;
                RESTDatabase db;
                if (searchableDatabase.searchInBio()) {
                    db = api.getRESTDb(BioFilter.ONLY_BIO, this.bioDatabase.getDatabasePath());
                    object2 = null;
                    try {
                        candidates.addAll(db.lookupMolecularFormulas(i.experiment.getIonMass(), dev, allowedIonTypes.toArray(new PrecursorIonType[allowedIonTypes.size()])));
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (db != null) {
                            if (object2 != null) {
                                try {
                                    db.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object2).addSuppressed(throwable);
                                }
                            } else {
                                db.close();
                            }
                        }
                    }
                }
                if (searchableDatabase.searchInPubchem()) {
                    db = api.getRESTDb(BioFilter.ONLY_NONBIO, this.pubchemDatabase.getDatabasePath());
                    object2 = null;
                    try {
                        candidates.addAll(db.lookupMolecularFormulas(i.experiment.getIonMass(), dev, allowedIonTypes.toArray(new PrecursorIonType[allowedIonTypes.size()])));
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (db != null) {
                            if (object2 != null) {
                                try {
                                    db.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object2).addSuppressed(throwable);
                                }
                            } else {
                                db.close();
                            }
                        }
                    }
                }
                if (searchableDatabase.isCustomDb()) {
                    candidates.addAll(this.getFileBasedDb(searchableDatabase).lookupMolecularFormulas(i.experiment.getIonMass(), dev, allowedIonTypes.toArray(new PrecursorIonType[allowedIonTypes.size()])));
                }
            }
            catch (Throwable db) {
                object = db;
                throw db;
            }
            finally {
                if (api != null) {
                    if (object != null) {
                        try {
                            api.close();
                        }
                        catch (Throwable db) {
                            ((Throwable)object).addSuppressed(db);
                        }
                    } else {
                        api.close();
                    }
                }
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Connection to database fails. Probably our webservice is currently offline. You can still use SIRIUS in offline mode - you just have to remove the database flags -d or --database because database search is not available in offline mode.", (Throwable)e);
            System.exit(1);
            return null;
        }
        HashSet<MolecularFormula> allowedSet = new HashSet<MolecularFormula>();
        for (List fc : candidates) {
            for (FormulaCandidate f : fc) {
                long bitset = f.getBitset();
                if (flag != 0L && (bitset & flag) == 0L || !allowedAlphabet.isSatisfied(f.getFormula())) continue;
                allowedSet.add(f.getFormula());
            }
        }
        return allowedSet;
    }

    private HashMap<String, Long> getDatabaseAliasMap() {
        HashMap<String, Long> aliasMap = new HashMap<String, Long>();
        for (DatasourceService.Sources source : DatasourceService.Sources.values()) {
            aliasMap.put(source.name.toLowerCase(), source.searchFlag);
        }
        aliasMap.put("biocyc", DatasourceService.Sources.METACYC.flag);
        aliasMap.put("bio", DatasourceService.Sources.BIO.searchFlag);
        aliasMap.put("unpd", DatasourceService.Sources.UNDP.flag);
        aliasMap.put(CONSIDER_ALL_FORMULAS, 0L);
        if (!(aliasMap.containsKey(((FingerIdOptions)this.options).getDatabase().toLowerCase()) || new File(((FingerIdOptions)this.options).getDatabase()).exists() || this.customDatabases.containsKey(((FingerIdOptions)this.options).getDatabase()))) {
            this.unknownDatabaseError(((FingerIdOptions)this.options).getDatabase().toLowerCase(), aliasMap);
        }
        return aliasMap;
    }

    private void unknownDatabaseError(String name, HashMap<String, Long> aliasMap) {
        ArrayList<String> knownDatabases = new ArrayList<String>();
        knownDatabases.addAll(aliasMap.keySet());
        knownDatabases.addAll(this.customDatabases.keySet());
        LoggerFactory.getLogger(this.getClass()).error("Unknown database '" + name + "'. Available are: " + Joiner.on((String)", ").join(knownDatabases));
        System.exit(1);
    }

    @Override
    public void setup() {
        this.initializeDatabaseCache();
        super.setup();
    }

    @Override
    protected CLI.CLIJobSubmitter newSubmitter(Iterator<Instance> instanceIterator) {
        return new FingerIdSubmitter(instanceIterator);
    }

    protected class FingerIdSubmitter
    extends CLI.CLIJobSubmitter {
        public FingerIdSubmitter(Iterator<Instance> instances) {
            super(FingeridCLI.this, instances);
        }

        @Override
        protected void submitJobs(BufferedJJobSubmitter.JobContainer watcher) {
            FingerIDJJob fij;
            super.submitJobs(watcher);
            if (((FingerIdOptions)FingeridCLI.this.options).isFingerid() && (fij = FingeridCLI.this.makeFingerIdJob((Instance)watcher.sourceInstance, (BasicJJob<List<IdentificationResult>>)((BasicJJob)watcher.getJob(Sirius.SiriusIdentificationJob.class)))) != null) {
                this.submitJob((JJob)fij, watcher);
            }
        }
    }

    protected static final class CandidateElement
    extends Scored<FingerprintCandidate> {
        protected final FingerIdResult origin;

        public CandidateElement(FingerIdResult ir, Scored<FingerprintCandidate> c) {
            super(c.getCandidate(), c.getScore());
            this.origin = ir;
        }
    }
}

