/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ms.cli;

import de.unijena.bioinf.ms.cli.CLI;
import de.unijena.bioinf.sirius.projectspace.ExperimentResult;
import de.unijena.bioinf.sirius.projectspace.Index;
import de.unijena.bioinf.sirius.projectspace.ProjectReader;
import de.unijena.bioinf.sirius.projectspace.ProjectWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import org.slf4j.LoggerFactory;

public class ProjectSpaceMerger
implements ProjectWriter {
    protected CLI<?> cli;
    protected File tempFile;
    protected HashSet<String> ignoreSet = new HashSet();
    protected boolean zip;
    protected ProjectWriter underlyingWriter;
    protected int numberOfWrittenExperiments;

    public ProjectSpaceMerger(CLI<?> cli, String file, boolean zip) throws IOException {
        this.cli = cli;
        this.zip = zip;
        ProjectReader reader = zip ? cli.getSiriusOutputReader(file, cli.getWorkspaceReadingEnvironmentForSirius(file)) : cli.getDirectoryOutputReader(file, cli.getWorkspaceReadingEnvironmentForDirectoryOutput(file));
        this.tempFile = File.createTempFile("sirius", ".sirius");
        this.tempFile.deleteOnExit();
        this.numberOfWrittenExperiments = 0;
        try (ProjectWriter pw = cli.getSiriusOutputWriter(this.tempFile.getAbsolutePath(), cli.getWorkspaceWritingEnvironmentForSirius(this.tempFile.getAbsolutePath()));){
            while (reader.hasNext()) {
                try {
                    ExperimentResult er = (ExperimentResult)reader.next();
                    pw.writeExperiment(er);
                    this.numberOfWrittenExperiments = Math.max(this.numberOfWrittenExperiments, ((Index)er.getExperiment().getAnnotation(Index.class, (Object)Index.NO_INDEX)).index);
                }
                catch (Throwable t) {
                    LoggerFactory.getLogger(ProjectSpaceMerger.class).error(t.getMessage(), t);
                }
            }
        }
        reader.close();
        Files.walkFileTree(new File(file).toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!attrs.isDirectory()) {
                    Files.delete(file);
                }
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return super.postVisitDirectory(dir, exc);
            }
        });
        this.underlyingWriter = zip ? cli.getSiriusOutputWriter(file, cli.getWorkspaceWritingEnvironmentForSirius(file)) : cli.getDirectoryOutputWriter(file, cli.getWorkspaceWritingEnvironmentForDirectoryOutput(file));
    }

    public int getNumberOfWrittenExperiments() {
        return this.numberOfWrittenExperiments;
    }

    public void writeExperiment(ExperimentResult result) throws IOException {
        this.underlyingWriter.writeExperiment(result);
        this.ignoreSet.add(result.getExperimentSource() + "_" + result.getExperimentName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try (ProjectReader reader = this.cli.getSiriusOutputReader(this.tempFile.getAbsolutePath(), this.cli.getWorkspaceReadingEnvironmentForSirius(this.tempFile.getAbsolutePath()));){
            while (reader.hasNext()) {
                ExperimentResult result = (ExperimentResult)reader.next();
                if (this.ignoreSet.contains(result.getExperimentSource() + "_" + result.getExperimentName())) continue;
                this.underlyingWriter.writeExperiment(result);
            }
        }
        finally {
            this.underlyingWriter.close();
        }
    }
}

