/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ms.cli;

import de.unijena.bioinf.jjobs.JobProgressEvent;
import de.unijena.bioinf.jjobs.JobProgressEventListener;
import de.unijena.bioinf.sirius.Feedback;
import de.unijena.bioinf.sirius.Progress;
import java.io.PrintStream;
import java.util.Locale;

public class ShellProgress
implements Progress,
JobProgressEventListener {
    private boolean shellMode;
    private PrintStream writer;
    private static char FRAME = (char)124;
    private static char UNREACHED = (char)46;
    private static char REACHED = (char)61;
    private static int width = 20;
    private double max;
    private StringBuilder buffer;
    private int fillEmptySpace = 0;
    private int prevPerc = 0;
    private static final DummyFeedback DUMMY_FEEDBACK = new DummyFeedback();

    public ShellProgress(PrintStream writer, boolean shellMode) {
        this.shellMode = shellMode;
        this.writer = writer;
        this.buffer = new StringBuilder(160);
    }

    public void init(double maxProgress) {
        if (!this.shellMode) {
            return;
        }
        this.clearBuffer();
        this.draw(0.0, maxProgress, "start computing");
        this.max = maxProgress;
        this.prevPerc = 0;
    }

    public void update(double currentProgress, double maxProgress, String value, Feedback feedback) {
        if (!this.shellMode) {
            this.writer.println(currentProgress);
        } else {
            this.clearBuffer();
            this.draw(currentProgress, maxProgress, value);
        }
    }

    private void draw(double currentProgress, double maxProgress, String value) {
        int k;
        double percentage = (double)width * currentProgress / maxProgress;
        int perc100 = (int)Math.max(0L, Math.min(100L, Math.round(percentage * 5.0)));
        this.buffer.append(FRAME);
        for (k = 0; k < width / 2; ++k) {
            this.buffer.append((double)k >= percentage ? UNREACHED : REACHED);
        }
        this.buffer.append(String.format(Locale.US, "%3d %%", perc100));
        for (k = width / 2; k < width; ++k) {
            this.buffer.append((double)k >= percentage ? UNREACHED : REACHED);
        }
        this.buffer.append(FRAME);
        this.buffer.append('\t');
        if (value.length() < this.buffer.length()) {
            int indent = (this.buffer.length() - 1 - value.length()) / 2;
            for (int i = 0; i < indent; ++i) {
                this.buffer.append(' ');
            }
        }
        this.buffer.append(value);
        this.writer.print(this.buffer);
        for (k = this.buffer.length(); k < this.fillEmptySpace; ++k) {
            this.writer.print(' ');
        }
        this.fillEmptySpace = 0;
        this.writer.flush();
    }

    private void clearBuffer() {
        this.writer.print('\r');
        this.fillEmptySpace = this.buffer.length();
        this.buffer.delete(0, this.buffer.length());
    }

    public void finished() {
        if (!this.shellMode) {
            return;
        }
        this.clearBuffer();
        this.draw(this.max, this.max, "computation finished");
        this.writer.print("\n");
    }

    public void info(String message) {
        this.writer.println();
        this.writer.println(message);
        this.buffer.delete(0, this.buffer.length());
    }

    public void progressChanged(JobProgressEvent progressEvent) {
        this.update(progressEvent.getNewValue().intValue(), progressEvent.getMaxValue().intValue(), "", DUMMY_FEEDBACK);
        if (progressEvent.hasMessage()) {
            this.info(progressEvent.getMessage());
        }
    }

    private static class DummyFeedback
    implements Feedback {
        private DummyFeedback() {
        }

        public void cancelComputation() {
        }

        public void stopComputationKeepResults() {
        }
    }
}

