/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ms.cli;

import com.lexicalscope.jewel.cli.Option;
import com.lexicalscope.jewel.cli.Unparsed;
import de.unijena.bioinf.ChemistryBase.chem.FormulaConstraints;
import de.unijena.bioinf.sirius.IsotopePatternHandling;
import java.io.File;
import java.util.List;

public interface SiriusOptions {
    @Option(shortName={"q"}, description="surpress shell output")
    public boolean isQuiet();

    @Option(shortName={"o"}, description="output directory.", defaultToNull=true)
    public String getOutput();

    @Option(longName={"sirius", "workspace"}, shortName={"w"}, description="store workspace into given file, such that it can be loaded by SIRIUS GUI afterwards", defaultToNull=true)
    public String getSirius();

    @Option(longName={"zodiac"}, description="run zodiac on a given sirius workspace.", hidden=true)
    public boolean isZodiac();

    @Option
    public boolean isVersion();

    @Option(shortName={"s"}, longName={"isotope"}, defaultValue={"both"}, description="how to handle isotope pattern data. Use 'score' to use them for ranking or 'filter' if you just want to remove candidates with bad isotope pattern. With 'both' you can use isotopes for filtering and scoring (default). Use 'omit' to ignore isotope pattern.")
    public IsotopePatternHandling getIsotopes();

    @Option(shortName={"c"}, longName={"candidates"}, description="Number of candidates in the output", defaultToNull=true)
    public Integer getNumberOfCandidates();

    @Option(shortName={"f"}, longName={"formula", "formulas"}, description="specify the neutral molecular formula of the measured compound to compute its tree or a list of candidate formulas the method should discriminate. Omit this option if you want to consider all possible molecular formulas", defaultToNull=true)
    public List<String> getFormula();

    @Option(longName={"no-recalibration"})
    public boolean isNotRecalibrating();

    @Option(longName={"ppm-max"}, description="allowed ppm for decomposing masses", defaultToNull=true)
    public Double getPPMMax();

    @Option(longName={"noise"}, description="median intensity of noise peaks", defaultToNull=true)
    public Double getMedianNoise();

    @Option(shortName={"Z"}, longName={"auto-charge"}, description="Use this option if the adduct type and/or ion mode of your compounds is unknown and you do not want to assume [M+H]+/[M-H]- as default. With the option enabled, SIRIUS will also search for other adduct types (e.g. [M+NH3+H]+ or even other ion modes (e.g. [M+Na]+) if no ion mode is specified.")
    public boolean isAutoCharge();

    @Option(shortName={"h"}, longName={"help"}, helpRequest=true)
    public boolean isHelp();

    @Option
    public boolean isCite();

    @Option(shortName={"p"}, description="name of the configuration profile. Some of the default profiles are: 'qtof', 'orbitrap', 'fticr'.", defaultValue={"default"})
    public String getProfile();

    @Option(longName={"disable-fast-mode"}, hidden=true)
    public boolean isDisableFastMode();

    @Option(shortName={"1"}, longName={"ms1"}, description="MS1 spectrum file name", minimum=0, defaultToNull=true)
    public List<File> getMs1();

    @Option(shortName={"2"}, longName={"ms2"}, description="MS2 spectra file names", minimum=0, defaultToNull=true)
    public List<File> getMs2();

    @Option(shortName={"z"}, longName={"parentmass", "precursor", "mz"}, description="the mass of the parent ion", defaultToNull=true)
    public Double getParentMz();

    @Option(shortName={"i"}, longName={"ion"}, description="the ionization/adduct of the MS/MS data. Example: [M+H]+, [M-H]-, [M+Cl]-, [M+Na]+, [M]+. You can also provide a comma separated list of adducts.", defaultToNull=true)
    public List<String> getIon();

    @Option(longName={"tree-timeout"}, description="Time out in seconds per fragmentation tree computations. 0 for an infinite amount of time. Default: 0", defaultValue={"0"})
    public int getTreeTimeout();

    @Option(longName={"compound-timeout"}, description="Maximal computation time for a single compound. 0 for an infinite amount of time. Default: 0", defaultValue={"0"})
    public int getInstanceTimeout();

    @Unparsed
    public List<String> getInput();

    @Option(shortName={"e"}, longName={"elements"}, description="The allowed elements. Write CHNOPSCl to allow the elements C, H, N, O, P, S and Cl. Add numbers in brackets to restrict the minimal and maximal allowed occurence of these elements: CHNOP[5]S[8]Cl[1-2]. When one number is given then it is interpreted as upperbound.", defaultToNull=true)
    public FormulaConstraints getElements();

    @Option(longName={"maxmz"}, description="Just consider compounds with a precursor mz lower or equal this maximum mz. All other compounds in the input file are ignored.", defaultToNull=true)
    public Double getMaxMz();

    @Option(longName={"mostintense-ms2"}, description="Only use the fragmentation spectrum with the most intense precursor peak (for each compound).")
    public boolean isMostIntenseMs2();

    @Option(longName={"trust-ion-prediction"}, description="By default we use MS1 information to select additional ionizations ([M+Na]+,[M+K]+,[M+Cl]-,[M+Br]-) for considerations. With this parameter we trust the MS1 prediction and only consider these found ionizations.")
    public boolean isTrustGuessIonFromMS1();

    @Option(longName={"processors", "cores"}, description="Number of cpu cores to use. If not specified Sirius uses all available cores.", defaultValue={"0"})
    public int getNumOfCores();

    @Option(longName={"max-compound-buffer"}, description="Maxmimal number of compounds that will be buffered in Memory. A larger buffer ensures that there are enough compounds available to use all cores efficiently during computation. A smaller buffer saves Memory. For Infinite buffer size set it to 0. Default: 2 * --initial_intance_buffer", defaultToNull=true)
    public Integer getMaxInstanceBuffer();

    @Option(longName={"initial-compound-buffer"}, description="Number of compounds that will be loaded initially into the Memory. A larger buffer ensures that there are enough compounds available to use all cores efficiently during computation. A smaller buffer saves Memory. To load all compounds immediately set it to 0. Default: 2 * --cores", defaultToNull=true)
    public Integer getMinInstanceBuffer();

    @Option(longName={"disable-element-detection"}, hidden=true)
    public boolean isDisableElementDetection();

    @Option(longName={"enable-silicon-detection"}, hidden=true)
    public boolean isEnableSiliconDetection();

    @Option(hidden=true)
    public boolean isPlaceholder();
}

