/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ms.cli;

import de.unijena.bioinf.ChemistryBase.algorithm.Scored;
import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.ms.CompoundQuality;
import de.unijena.bioinf.ChemistryBase.ms.MeasurementProfile;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Dataset;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.MutableMs2Dataset;
import de.unijena.bioinf.ChemistryBase.ms.MutableMs2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.SpectrumProperty;
import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.ChemistryBase.ms.ft.TreeScoring;
import de.unijena.bioinf.ChemistryBase.ms.utils.SimpleSpectrum;
import de.unijena.bioinf.ChemistryBase.properties.PropertyManager;
import de.unijena.bioinf.GibbsSampling.ZodiacUtils;
import de.unijena.bioinf.GibbsSampling.model.Candidate;
import de.unijena.bioinf.GibbsSampling.model.CompoundResult;
import de.unijena.bioinf.GibbsSampling.model.Connectivity;
import de.unijena.bioinf.GibbsSampling.model.DummyFragmentCandidate;
import de.unijena.bioinf.GibbsSampling.model.EdgeFilter;
import de.unijena.bioinf.GibbsSampling.model.EdgeScorer;
import de.unijena.bioinf.GibbsSampling.model.EdgeThresholdFilter;
import de.unijena.bioinf.GibbsSampling.model.EdgeThresholdMinConnectionsFilter;
import de.unijena.bioinf.GibbsSampling.model.FragmentsCandidate;
import de.unijena.bioinf.GibbsSampling.model.LibraryHitScorer;
import de.unijena.bioinf.GibbsSampling.model.LocalEdgeFilter;
import de.unijena.bioinf.GibbsSampling.model.NodeScorer;
import de.unijena.bioinf.GibbsSampling.model.Reaction;
import de.unijena.bioinf.GibbsSampling.model.StandardNodeScorer;
import de.unijena.bioinf.GibbsSampling.model.ZodiacResultsWithClusters;
import de.unijena.bioinf.GibbsSampling.model.distributions.ExponentialDistribution;
import de.unijena.bioinf.GibbsSampling.model.distributions.LogNormalDistribution;
import de.unijena.bioinf.GibbsSampling.model.distributions.ScoreProbabilityDistribution;
import de.unijena.bioinf.GibbsSampling.model.distributions.ScoreProbabilityDistributionEstimator;
import de.unijena.bioinf.GibbsSampling.model.distributions.ScoreProbabilityDistributionFix;
import de.unijena.bioinf.GibbsSampling.model.scorer.CommonFragmentAndLossScorer;
import de.unijena.bioinf.GibbsSampling.model.scorer.EdgeScorings;
import de.unijena.bioinf.babelms.MsExperimentParser;
import de.unijena.bioinf.babelms.ms.JenaMsWriter;
import de.unijena.bioinf.ms.cli.ZodiacOptions;
import de.unijena.bioinf.sirius.IdentificationResult;
import de.unijena.bioinf.sirius.Ms2DatasetPreprocessor;
import de.unijena.bioinf.sirius.Sirius;
import de.unijena.bioinf.sirius.projectspace.DirectoryReader;
import de.unijena.bioinf.sirius.projectspace.ExperimentResult;
import de.unijena.bioinf.sirius.projectspace.SiriusFileReader;
import de.unijena.bioinf.sirius.projectspace.SiriusWorkspaceReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;

public class Zodiac {
    private static final Logger LOG = LoggerFactory.getLogger(Zodiac.class);
    private Path outputPath;
    private Path libraryHitsFile;
    private Path workSpacePath;
    private ZodiacOptions options;
    private int maxCandidates;
    private static final int NUMBER_OF_HITS = Integer.MAX_VALUE;
    private static final String SEP = "\t";

    public Zodiac(ZodiacOptions options) {
        this.workSpacePath = Paths.get(options.getSirius(), new String[0]);
        this.libraryHitsFile = options.getLibraryHitsFile() == null ? null : Paths.get(options.getLibraryHitsFile(), new String[0]);
        this.outputPath = Paths.get(options.getOutput(), new String[0]);
        this.options = options;
    }

    public void run() {
        this.maxCandidates = this.options.getNumberOfCandidates() == null ? Integer.MAX_VALUE : this.options.getNumberOfCandidates();
        Path originalSpectraPath = Paths.get(this.options.getSpectraFile(), new String[0]);
        try {
            NodeScorer[] nodeScorers;
            int workerCount = this.options.getNumOfCores() > 0 ? this.options.getNumOfCores() : new SystemInfo().getHardware().getProcessor().getPhysicalProcessorCount() - 1;
            PropertyManager.PROPERTIES.setProperty("de.unijena.bioinf.sirius.cpu.cores", String.valueOf(workerCount));
            if (Files.exists(this.outputPath, new LinkOption[0])) {
                if (!Files.isDirectory(this.outputPath, new LinkOption[0])) {
                    LOG.error("specified output path must be a directory.");
                    return;
                }
            } else {
                Files.createDirectories(this.outputPath, new FileAttribute[0]);
            }
            List<ExperimentResult> experimentResults = Zodiac.newLoad(this.workSpacePath.toFile());
            experimentResults = this.updateQuality(experimentResults, originalSpectraPath);
            List anchors = this.libraryHitsFile == null ? null : ZodiacUtils.parseLibraryHits((Path)this.libraryHitsFile, (Path)originalSpectraPath, (Logger)LOG);
            boolean useLibraryHits = this.libraryHitsFile != null;
            double libraryScore = 1.0;
            if (useLibraryHits) {
                Reaction[] reactions = ZodiacUtils.parseReactions((int)1);
                HashSet<MolecularFormula> netSingleReactionDiffs = new HashSet<MolecularFormula>();
                for (Reaction reaction : reactions) {
                    netSingleReactionDiffs.add(reaction.netChange());
                }
                nodeScorers = new NodeScorer[]{new StandardNodeScorer(true, 1.0), new LibraryHitScorer(libraryScore, 0.3, netSingleReactionDiffs)};
            } else {
                nodeScorers = new NodeScorer[]{new StandardNodeScorer(true, 1.0)};
            }
            EdgeThresholdFilter edgeFilter = null;
            if (this.options.getThresholdFilter() > 0.0 && ((double)this.options.getLocalFilter() > 0.0 || (double)this.options.getMinLocalConnections() > 0.0)) {
                int numberOfCandidates = Math.max(this.options.getLocalFilter(), 1);
                int numberOfConnections = this.options.getMinLocalConnections() > 0 ? this.options.getMinLocalConnections() : 10;
                edgeFilter = new EdgeThresholdMinConnectionsFilter(this.options.getThresholdFilter(), numberOfCandidates, numberOfConnections);
            } else if (this.options.getThresholdFilter() > 0.0) {
                edgeFilter = new EdgeThresholdFilter(this.options.getThresholdFilter());
            } else if ((double)this.options.getLocalFilter() > 0.0) {
                edgeFilter = new LocalEdgeFilter((double)this.options.getLocalFilter());
            }
            if (edgeFilter == null) {
                edgeFilter = new EdgeThresholdFilter(0.0);
            }
            boolean estimateByMedian = true;
            ExponentialDistribution probabilityDistribution = null;
            if (this.options.getProbabilityDistribution().equals((Object)EdgeScorings.exponential)) {
                probabilityDistribution = new ExponentialDistribution(estimateByMedian);
            } else if (this.options.getProbabilityDistribution().equals((Object)EdgeScorings.lognormal)) {
                probabilityDistribution = new LogNormalDistribution(estimateByMedian);
            } else {
                LOG.error("probability distribution is unknown. Use 'lognormal' or 'exponential'.");
                return;
            }
            double minimumOverlap = 0.0;
            Object commonFragmentAndLossScorer = this.options.isEstimateDistribution() ? new ScoreProbabilityDistributionEstimator((EdgeScorer)new CommonFragmentAndLossScorer(minimumOverlap), (ScoreProbabilityDistribution)probabilityDistribution, this.options.getThresholdFilter()) : new ScoreProbabilityDistributionFix((EdgeScorer)new CommonFragmentAndLossScorer(minimumOverlap), (ScoreProbabilityDistribution)probabilityDistribution, this.options.getThresholdFilter());
            EdgeScorer[] edgeScorers = new EdgeScorer[]{commonFragmentAndLossScorer};
            de.unijena.bioinf.GibbsSampling.Zodiac zodiac = new de.unijena.bioinf.GibbsSampling.Zodiac(experimentResults, anchors, nodeScorers, edgeScorers, (EdgeFilter)edgeFilter, this.maxCandidates);
            ZodiacResultsWithClusters zodiacResult = zodiac.compute(this.options.getIterationSteps(), this.options.getBurnInSteps(), this.options.getSeparateRuns());
            CompoundResult[] result = zodiacResult.getResults();
            String[] ids = zodiacResult.getIds();
            Map<String, ExperimentResult> experimentResultMap = this.createMap(experimentResults);
            Map representativeToCluster = zodiacResult.getRepresentativeToCluster();
            Scored<IdentificationResult>[] bestInitial = this.bestInitial(ids, experimentResultMap);
            Zodiac.writeZodiacOutput(ids, bestInitial, result, this.outputPath.resolve("zodiac_summary.csv"));
            Zodiac.writeClusters(representativeToCluster, this.outputPath.resolve("clusters.csv"));
            Zodiac.writeSpectra(ids, result, experimentResultMap, this.outputPath);
        }
        catch (IOException e) {
            LOG.error("Error while running ZODIAC: " + e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private List<ExperimentResult> updateQuality(List<ExperimentResult> experimentResults, Path originalMsInformation) throws IOException {
        MsExperimentParser parser = new MsExperimentParser();
        List rawExperiments = parser.getParser(originalMsInformation.toFile()).parseFromFile(originalMsInformation.toFile());
        HashMap<String, ArrayList<Object>> nameToExperiment = new HashMap<String, ArrayList<Object>>();
        for (Object rawExperiment : rawExperiments) {
            String name = rawExperiment.getName();
            ArrayList<Object> experimentList = (ArrayList<Object>)nameToExperiment.get(name);
            if (experimentList == null) {
                experimentList = new ArrayList<Object>();
                nameToExperiment.put(name, experimentList);
            }
            experimentList.add(rawExperiment);
        }
        List<MutableMs2Experiment> allExperiments = new ArrayList();
        for (ExperimentResult result : experimentResults) {
            MutableMs2Experiment mutableMs2Experiment = new MutableMs2Experiment(result.getExperiment());
            String name = mutableMs2Experiment.getName();
            List experimentList = (List)nameToExperiment.get(name);
            Ms2Experiment experiment2 = null;
            if (experimentList.size() == 1) {
                experiment2 = (Ms2Experiment)experimentList.get(0);
            } else if (experimentList.size() > 1) {
                for (Ms2Experiment experiment : experimentList) {
                    if (!(Math.abs(mutableMs2Experiment.getIonMass() - experiment.getIonMass()) < 1.0E-15)) continue;
                    experiment2 = experiment;
                    break;
                }
            }
            if (experiment2 == null) {
                LOG.error("cannot find original MS data for compound in sirius workspace: " + mutableMs2Experiment.getName());
            } else {
                mutableMs2Experiment.setMergedMs1Spectrum((SimpleSpectrum)experiment2.getMergedMs1Spectrum());
                mutableMs2Experiment.setMs1Spectra(experiment2.getMs1Spectra());
                mutableMs2Experiment.setMs2Spectra(experiment2.getMs2Spectra());
            }
            allExperiments.add(mutableMs2Experiment);
        }
        MutableMs2Dataset dataset = new MutableMs2Dataset(allExperiments, "default", Double.NaN, (MeasurementProfile)new Sirius("default").getMs2Analyzer().getDefaultProfile());
        Ms2DatasetPreprocessor preprocessor = new Ms2DatasetPreprocessor(true);
        dataset = preprocessor.preprocess((Ms2Dataset)dataset);
        allExperiments = dataset.getExperiments();
        int pos = 0;
        ArrayList<ExperimentResult> newExperimentResults = new ArrayList<ExperimentResult>();
        for (ExperimentResult result : experimentResults) {
            Ms2Experiment experiment;
            ArrayList<FTree> trees = new ArrayList<FTree>();
            experiment = (Ms2Experiment)allExperiments.get(pos++);
            for (IdentificationResult identificationResult : result.getResults()) {
                trees.add(identificationResult.getResolvedTree());
            }
            if (!Zodiac.atLeastOneTreeExplainsSomeIntensity(trees, 0.5)) {
                CompoundQuality.setProperty((Ms2Experiment)experiment, (SpectrumProperty)SpectrumProperty.PoorlyExplained);
            }
            if (!Zodiac.atLeastOneTreeExplainsSomePeaks(trees, 3)) {
                CompoundQuality.setProperty((Ms2Experiment)experiment, (SpectrumProperty)SpectrumProperty.PoorlyExplained);
            }
            newExperimentResults.add(new ExperimentResult(experiment, result.getResults()));
        }
        return newExperimentResults;
    }

    public static boolean atLeastOneTreeExplainsSomeIntensity(List<FTree> trees, double threshold) {
        for (FTree tree : trees) {
            double intensity = ((TreeScoring)tree.getAnnotationOrThrow(TreeScoring.class)).getExplainedIntensity();
            if (!(intensity > threshold)) continue;
            return true;
        }
        return false;
    }

    public static boolean atLeastOneTreeExplainsSomePeaks(List<FTree> trees, int threshold) {
        for (FTree tree : trees) {
            if (tree.numberOfVertices() < threshold) continue;
            return true;
        }
        return false;
    }

    public static void writeZodiacOutput(String[] ids, Scored<IdentificationResult>[] initial, CompoundResult<FragmentsCandidate>[] result, Path outputPath) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(outputPath, Charset.defaultCharset(), new OpenOption[0]);
        writer.write("id\tSiriusMF\tSiriusScore\tconnectedCompounds\tZodiacMF\tZodiacScore");
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            String id2 = result[i].getId();
            if (!id.equals(id2)) {
                throw new RuntimeException("different ids: " + id + " vs " + id2);
            }
            String siriusMF = ((IdentificationResult)initial[i].getCandidate()).getMolecularFormula().formatByHill();
            double siriusScore = initial[i].getScore();
            int connections = ((Connectivity)result[i].getAnnotationOrThrow(Connectivity.class)).getNumberOfConnectedCompounds();
            String summeryLine = Zodiac.createSummaryLine(id, siriusMF, siriusScore, connections, result[i].getCandidates());
            writer.write("\n");
            writer.write(summeryLine);
        }
        writer.close();
    }

    private static String createSummaryLine(String id, String siriusMF, double siriusScore, int numberConnections, Scored<FragmentsCandidate>[] result) {
        StringBuilder builder = new StringBuilder();
        builder.append(id);
        builder.append(SEP);
        builder.append(siriusMF);
        builder.append(SEP);
        builder.append(Double.toString(siriusScore));
        builder.append(SEP);
        builder.append(numberConnections);
        for (int j = 0; j < Math.min(result.length, Integer.MAX_VALUE); ++j) {
            Scored<FragmentsCandidate> currentResult = result[j];
            String mf = ((FragmentsCandidate)currentResult.getCandidate()).getFormula().formatByHill();
            double score = currentResult.getScore();
            if (score <= 0.0) break;
            builder.append(SEP);
            builder.append(mf);
            builder.append(SEP);
            builder.append(Double.toString(score));
        }
        return builder.toString();
    }

    private Scored<IdentificationResult>[] bestInitial(String[] ids, Map<String, ExperimentResult> experimentResultMap) {
        Scored[] best = new Scored[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            ExperimentResult result = experimentResultMap.get(id);
            double max = Double.NEGATIVE_INFINITY;
            for (IdentificationResult identificationResult : result.getResults()) {
                double score = identificationResult.getScore();
                if (!(score > max)) continue;
                max = score;
            }
            double sum = 0.0;
            double[] scores = new double[result.getResults().size()];
            for (int j = 0; j < result.getResults().size(); ++j) {
                IdentificationResult identificationResult = (IdentificationResult)result.getResults().get(j);
                double expS = Math.exp(1.0 * (identificationResult.getScore() - max));
                sum += expS;
                scores[j] = expS;
            }
            best[i] = new Scored(result.getResults().get(0), scores[0] / sum);
        }
        return best;
    }

    private Map<String, ExperimentResult> createMap(List<ExperimentResult> experimentResults) {
        HashMap<String, ExperimentResult> map = new HashMap<String, ExperimentResult>();
        for (ExperimentResult experimentResult : experimentResults) {
            map.put(experimentResult.getExperimentName(), experimentResult);
        }
        return map;
    }

    protected static List<ExperimentResult> newLoad(File file) throws IOException {
        ArrayList<ExperimentResult> results = new ArrayList<ExperimentResult>();
        Object env = file.isDirectory() ? new SiriusFileReader(file) : new SiriusWorkspaceReader(file);
        DirectoryReader reader = new DirectoryReader((DirectoryReader.ReadingEnvironment)env);
        while (reader.hasNext()) {
            ExperimentResult result = reader.next();
            results.add(result);
        }
        return results;
    }

    private static void writeClusters(Map<String, String[]> representativeToCluster, Path outputPath) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(outputPath, Charset.defaultCharset(), new OpenOption[0]);
        writer.write("representative\tcluster_ids");
        for (Map.Entry<String, String[]> stringEntry : representativeToCluster.entrySet()) {
            String repId = stringEntry.getKey();
            String[] ids = stringEntry.getValue();
            StringJoiner joiner = new StringJoiner(SEP);
            joiner.add(repId);
            for (String id : ids) {
                joiner.add(id);
            }
            writer.write("\n");
            writer.write(joiner.toString());
        }
        writer.close();
    }

    private static void writeSpectra(String[] ids, CompoundResult<FragmentsCandidate>[] result, Map<String, ExperimentResult> experimentMap, Path outputPath) throws IOException {
        for (int i = 0; i < ids.length; ++i) {
            Scored[] currentResults = result[i].getCandidates();
            Scored bestResult = currentResults[0];
            if (DummyFragmentCandidate.isDummy((Candidate)((Candidate)bestResult.getCandidate()))) continue;
            String id = ids[i];
            MutableMs2Experiment experiment = new MutableMs2Experiment(experimentMap.get(id).getExperiment());
            experiment.setMolecularFormula(((FragmentsCandidate)bestResult.getCandidate()).getFormula());
            experiment.setPrecursorIonType(((FragmentsCandidate)bestResult.getCandidate()).getIonType());
            Path file = outputPath.resolve(Integer.toString(i + 1) + "_" + id + ".ms");
            BufferedWriter writer = Files.newBufferedWriter(file, Charset.defaultCharset(), new OpenOption[0]);
            new JenaMsWriter().write(writer, (Ms2Experiment)experiment);
            writer.close();
        }
    }
}

