/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ms.cli;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.HelpRequestedException;
import de.unijena.bioinf.ms.cli.FingerIdOptions;
import de.unijena.bioinf.ms.cli.FingeridCLI;
import de.unijena.bioinf.ms.cli.Zodiac;
import de.unijena.bioinf.ms.cli.ZodiacOptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.slf4j.LoggerFactory;

public class ZodiacCLI<Options extends FingerIdOptions>
extends FingeridCLI<Options> {
    private ZodiacOptions zodiacOptions;

    @Override
    public void compute() {
        if (((FingerIdOptions)this.options).isZodiac()) {
            Zodiac zodiac = new Zodiac(this.zodiacOptions);
            zodiac.run();
        } else {
            super.compute();
        }
    }

    @Override
    public void parseArgs(String[] args, Class<Options> optionsClass) {
        try {
            if (this.isZodiac(args)) {
                if (args.length == 1) {
                    System.out.println(CliFactory.createCli(ZodiacOptions.class).getHelpMessage());
                    System.exit(0);
                }
                String[] argsNew = ZodiacCLI.removeFromArrayIgnoreCase(args, "--zodiac");
                this.zodiacOptions = (ZodiacOptions)CliFactory.createCli(ZodiacOptions.class).parseArguments(argsNew);
                super.parseArgs(new String[]{"--zodiac"}, optionsClass);
            } else {
                super.parseArgs(args, optionsClass);
            }
        }
        catch (HelpRequestedException e) {
            super.parseArgs(args, optionsClass);
        }
    }

    private boolean isZodiac(String[] args) {
        for (String arg : args) {
            if (!arg.toLowerCase().equals("--zodiac")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setup() {
        if (!((FingerIdOptions)this.options).isZodiac()) {
            super.setup();
            return;
        }
        Path output = Paths.get(this.zodiacOptions.getOutput(), new String[0]);
        if (!Files.exists(output, new LinkOption[0])) {
            try {
                Files.createDirectories(output, new FileAttribute[0]);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Cannot create output directory: " + e.getMessage());
            }
        }
    }

    @Override
    public void validate() {
        if (!((FingerIdOptions)this.options).isZodiac()) {
            super.validate();
            return;
        }
        Path output = Paths.get(this.zodiacOptions.getOutput(), new String[0]);
        if (!Files.isDirectory(output, new LinkOption[0]) && Files.exists(output, new LinkOption[0])) {
            LoggerFactory.getLogger(this.getClass()).error("the output must be a directory or non-existing.");
            System.exit(1);
        }
    }

    private static String[] removeFromArrayIgnoreCase(String[] args, String param) {
        int idx = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(param)) continue;
            idx = i;
            break;
        }
        if (idx < 0) {
            return (String[])args.clone();
        }
        String[] argsNew = Arrays.copyOf(args, args.length - 1);
        for (int i = idx + 1; i < args.length; ++i) {
            argsNew[i - 1] = args[i];
        }
        return argsNew;
    }
}

