/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius.core;

import de.unijena.bioinf.ChemistryBase.properties.PersistentProperties;
import de.unijena.bioinf.ChemistryBase.properties.PropertyManager;
import de.unijena.bioinf.FragmentationTreeConstruction.computation.tree.TreeBuilderFactory;
import de.unijena.bioinf.utils.errorReport.ErrorReporter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;

public abstract class ApplicationCore {
    public static final Logger DEFAULT_LOGGER;
    private static final String USER_PROPERTIES_FILE_HAEDER = "This is the default Sirius properties file containing default values for all sirius properties that can be set";
    public static final Path WORKSPACE;
    public static final String VERSION_STRING;
    public static final String CITATION;
    public static final String CITATION_BIBTEX;
    public static final PersistentProperties SIRIUS_PROPERTIES_FILE;

    private static void deleteFromWorkspace(Path ... files) {
        for (Path file : files) {
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException e) {
                System.err.println("Could NOT delete " + file.toAbsolutePath().toString());
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String version = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.version");
        String build = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.build");
        String home = System.getProperty("user.home");
        String path = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.ws", ".sirius");
        Path DEFAULT_WORKSPACE = Paths.get(home, new String[0]).resolve(path);
        Map<String, String> env = System.getenv();
        String ws = env.get("SIRIUS_WORKSPACE");
        if (ws != null) {
            Path wsDir = Paths.get(ws, new String[0]);
            if (Files.isDirectory(wsDir, new LinkOption[0])) {
                WORKSPACE = wsDir;
            } else if (Files.notExists(wsDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(wsDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    System.err.println("Could not create Workspace set in environment variable! Falling back to default Workspace - " + DEFAULT_WORKSPACE.toString());
                    e.printStackTrace();
                    wsDir = DEFAULT_WORKSPACE;
                }
                finally {
                    WORKSPACE = wsDir;
                }
            } else {
                System.err.println("WARNING: " + wsDir.toString() + " is not a directory! Falling back to default Workspace - " + DEFAULT_WORKSPACE.toString());
                WORKSPACE = DEFAULT_WORKSPACE;
            }
        } else {
            WORKSPACE = DEFAULT_WORKSPACE;
        }
        if (Files.notExists(WORKSPACE, new LinkOption[0])) {
            try {
                Files.createDirectories(WORKSPACE, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.err.println("Could NOT create Workspace");
                e.printStackTrace();
                System.exit(1);
            }
        }
        Path loggingPropFile = WORKSPACE.resolve("logging.properties");
        Path siriusPropsFile = WORKSPACE.resolve("sirius.properties");
        Path versionFile = WORKSPACE.resolve("version");
        try {
            if (Files.exists(versionFile, new LinkOption[0])) {
                List<String> lines = Files.readAllLines(versionFile);
                if (lines == null || lines.isEmpty() || !lines.get(0).equals(version)) {
                    ApplicationCore.deleteFromWorkspace(loggingPropFile, siriusPropsFile, versionFile);
                    Files.write(versionFile, version.getBytes(), StandardOpenOption.CREATE);
                }
            } else {
                ApplicationCore.deleteFromWorkspace(loggingPropFile, siriusPropsFile, versionFile);
                Files.write(versionFile, version.getBytes(), StandardOpenOption.CREATE);
            }
        }
        catch (IOException e) {
            System.err.println("Error while reading/writing workspace version file!");
            e.printStackTrace();
            ApplicationCore.deleteFromWorkspace(loggingPropFile, siriusPropsFile, versionFile);
            try {
                Files.write(versionFile, version.getBytes(), StandardOpenOption.CREATE);
            }
            catch (IOException e1) {
                System.err.println("Error while writing workspace version file!");
                e1.printStackTrace();
            }
        }
        if (Files.notExists(loggingPropFile, new LinkOption[0])) {
            try (InputStream input = ApplicationCore.class.getResourceAsStream("/logging.properties");){
                Files.copy(input, loggingPropFile, new CopyOption[0]);
            }
            catch (IOException | NullPointerException e) {
                System.err.println("Could not set logging properties, using default java logging properties and directories");
                e.printStackTrace();
            }
        }
        if (Files.exists(loggingPropFile, new LinkOption[0])) {
            Properties logProps = new Properties();
            try (InputStream input = Files.newInputStream(loggingPropFile, StandardOpenOption.READ);){
                logProps.load(input);
            }
            catch (IOException | NullPointerException e) {
                System.err.println("Could not set logging properties, using default java logging properties and directories");
                e.printStackTrace();
            }
            try {
                String errorReportHandlerClassName = "de.unijena.bioinf.sirius.core.errorReport.ErrorReportHandler";
                ClassLoader.getSystemClassLoader().loadClass(errorReportHandlerClassName);
                String handlers = logProps.getProperty("handlers");
                handlers = handlers != null && !handlers.isEmpty() ? handlers + "," + errorReportHandlerClassName : errorReportHandlerClassName;
                logProps.put("handlers", handlers);
                logProps.put("de.unijena.bioinf.sirius.core.errorReport.ErrorReportHandler.level", "CONFIG");
                logProps.put("de.unijena.bioinf.sirius.core.errorReport.ErrorReportHandler.formatter", "java.util.logging.SimpleFormatter");
            }
            catch (ClassNotFoundException errorReportHandlerClassName) {
                // empty catch block
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                logProps.store(out, "Auto generated in memory prop file");
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                LogManager.getLogManager().readConfiguration(in);
            }
            catch (IOException e) {
                System.err.println("Could not read logging configuration.");
                e.printStackTrace();
            }
        }
        DEFAULT_LOGGER = LoggerFactory.getLogger(ApplicationCore.class);
        DEFAULT_LOGGER.debug("Logging service initialized!");
        DEFAULT_LOGGER.debug("java.library.path = " + System.getProperty("java.library.path"));
        DEFAULT_LOGGER.debug("LD_LIBRARY_PATH = " + System.getenv("LD_LIBRARY_PATH"));
        DEFAULT_LOGGER.debug("java.class.path = " + System.getProperty("java.class.path"));
        DEFAULT_LOGGER.info("Sirius Workspace Successfull initialized at: " + WORKSPACE.toAbsolutePath().toString());
        VERSION_STRING = version != null && build != null ? "Sirius " + version + " (build " + build + ")" : "Sirius";
        DEFAULT_LOGGER.debug(VERSION_STRING);
        String prop = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.cite");
        CITATION = prop != null ? prop : "";
        prop = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.cite-bib");
        CITATION_BIBTEX = prop != null ? prop : "";
        DEFAULT_LOGGER.debug("build properties initialized!");
        Properties defaultProps = new Properties();
        try (InputStream stream = ApplicationCore.class.getResourceAsStream("/sirius.properties");){
            defaultProps.load(stream);
            defaultProps.put("de.unijena.bioinf.sirius.fingerID.cache", WORKSPACE.resolve("csi_fingerid_cache").toString());
        }
        catch (IOException e) {
            DEFAULT_LOGGER.error("Could NOT create sirius properties file", (Throwable)e);
        }
        SIRIUS_PROPERTIES_FILE = new PersistentProperties(siriusPropsFile, defaultProps, USER_PROPERTIES_FILE_HAEDER);
        SIRIUS_PROPERTIES_FILE.store();
        PropertyManager.PROPERTIES.setProperty("de.unijena.bioinf.sirius.workspace", WORKSPACE.toAbsolutePath().toString());
        DEFAULT_LOGGER.debug("application properties initialized!");
        DEFAULT_LOGGER.info(TreeBuilderFactory.ILP_VERSIONS_STRING);
        DEFAULT_LOGGER.info("Treebuilder priorities are: " + Arrays.toString(TreeBuilderFactory.getBuilderPriorities()));
        HardwareAbstractionLayer hardware = new SystemInfo().getHardware();
        int cores = hardware.getProcessor().getPhysicalProcessorCount();
        PropertyManager.PROPERTIES.setProperty("de.unijena.bioinf.sirius.cpu.cores", String.valueOf(cores));
        PropertyManager.PROPERTIES.setProperty("de.unijena.bioinf.sirius.cpu.threads", String.valueOf(hardware.getProcessor().getLogicalProcessorCount()));
        DEFAULT_LOGGER.info("CPU check done. " + PropertyManager.getNumberOfCores() + " cores that handle " + PropertyManager.getNumberOfThreads() + " threads were found.");
        ErrorReporter.INIT_PROPS((Properties)PropertyManager.PROPERTIES);
        DEFAULT_LOGGER.info("Bug reporter initialized!");
    }
}

