/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius.net;

import de.unijena.bioinf.ChemistryBase.properties.PropertyManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.slf4j.LoggerFactory;

public class ProxyManager {
    public static final boolean DEBUG = false;
    public static final String HTTPS_SCHEME = "https";
    public static final String HTTP_SCHEME = "http";
    public static final int OK_STATE = 0;
    public static final ProxyStrategy DEFAULT_STRATEGY = ProxyStrategy.SYSTEM;

    public static ProxyStrategy getStrategyByName(String vlaue) {
        try {
            return ProxyStrategy.valueOf(vlaue);
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(ProxyStrategy.class).debug("Invalid Proxy Strategy state!", (Throwable)e);
            return null;
        }
    }

    public static ProxyStrategy getProxyStrategy() {
        return ProxyManager.getStrategyByName(PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.proxy", ProxyStrategy.SYSTEM.name()));
    }

    public static boolean useSystemProxyConfig() {
        return ProxyManager.getProxyStrategy() == ProxyStrategy.SYSTEM;
    }

    public static boolean useSiriusProxyConfig() {
        return ProxyManager.getProxyStrategy() == ProxyStrategy.SIRIUS;
    }

    public static boolean useNoProxyConfig() {
        return ProxyManager.getProxyStrategy() == ProxyStrategy.NONE;
    }

    public static CloseableHttpClient getSirirusHttpClient() {
        return ProxyManager.getSirirusHttpClient(ProxyManager.getProxyStrategy());
    }

    public static CloseableHttpClient getSirirusHttpClient(ProxyStrategy strategy) {
        CloseableHttpClient client;
        switch (strategy) {
            case SYSTEM: {
                client = ProxyManager.getJavaDefaultProxyClient();
                LoggerFactory.getLogger(ProxyStrategy.class).debug("Using Proxy Type " + (Object)((Object)ProxyStrategy.SYSTEM));
                break;
            }
            case SIRIUS: {
                client = ProxyManager.getSiriusProxyClient();
                LoggerFactory.getLogger(ProxyStrategy.class).debug("Using Proxy Type " + (Object)((Object)ProxyStrategy.SIRIUS));
                break;
            }
            case NONE: {
                client = ProxyManager.getNoProxyClient();
                LoggerFactory.getLogger(ProxyStrategy.class).debug("Using Proxy Type " + (Object)((Object)ProxyStrategy.NONE));
                break;
            }
            default: {
                client = ProxyManager.getJavaDefaultProxyClient();
                LoggerFactory.getLogger(ProxyStrategy.class).debug("Using FALLBACK Proxy Type " + (Object)((Object)ProxyStrategy.SYSTEM));
            }
        }
        return client;
    }

    public static CloseableHttpClient getTestedHttpClient() {
        return ProxyManager.getTestedHttpClient(true);
    }

    public static CloseableHttpClient getTestedHttpClient(boolean failover) {
        CloseableHttpClient client = ProxyManager.getSirirusHttpClient();
        if (ProxyManager.hasInternetConnection(client)) {
            return client;
        }
        if (failover) {
            LoggerFactory.getLogger(ProxyManager.class).warn("No connection with selected setting. Searching for Failover Settings!");
            for (ProxyStrategy strategy : ProxyStrategy.values()) {
                CloseableHttpClient failoverClient = ProxyManager.getSirirusHttpClient(strategy);
                if (!ProxyManager.hasInternetConnection(client)) continue;
                client = failoverClient;
                break;
            }
        }
        return client;
    }

    public static int checkInternetConnection(CloseableHttpClient client) {
        if (!ProxyManager.checkBioinf(client)) {
            if (!ProxyManager.checkJena(client)) {
                if (!ProxyManager.checkExternal(client)) {
                    return 1;
                }
                return 2;
            }
            return 3;
        }
        return 0;
    }

    public static int checkInternetConnection() {
        CloseableHttpClient client = ProxyManager.getSirirusHttpClient();
        int val = ProxyManager.checkInternetConnection(client);
        return val;
    }

    public static boolean hasInternetConnection(CloseableHttpClient client) {
        return ProxyManager.checkInternetConnection(client) == 0;
    }

    public static boolean hasInternetConnection() {
        return ProxyManager.checkInternetConnection() == 0;
    }

    private static CloseableHttpClient getJavaDefaultProxyClient() {
        return HttpClients.createSystem();
    }

    private static CloseableHttpClient getNoProxyClient() {
        return HttpClients.createDefault();
    }

    private static CloseableHttpClient getSiriusProxyClient() {
        String hostName = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.proxy.hostname");
        int port = Integer.valueOf(PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.proxy.port"));
        String scheme = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.proxy.scheme");
        if (Boolean.getBoolean(PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.proxy.credentials"))) {
            return ProxyManager.getClientBuilderWithProxySettings(hostName, port, scheme, PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.proxy.credentials.user"), PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.proxy.credentials.pw")).build();
        }
        return ProxyManager.getClientBuilderWithProxySettings(hostName, port, scheme).build();
    }

    private static HttpClientBuilder getClientBuilderWithProxySettings(String hostname, int port, String scheme) {
        return ProxyManager.getClientBuilderWithProxySettings(hostname, port, scheme, null, null);
    }

    private static HttpClientBuilder getClientBuilderWithProxySettings(String hostname, int port, String scheme, String username, String password) {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        BasicCredentialsProvider clientCredentials = new BasicCredentialsProvider();
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)clientCredentials);
        HttpHost proxy = new HttpHost(hostname, port, scheme);
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
        clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        if (username != null && password != null) {
            clientCredentials.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(username, password));
        }
        return clientBuilder;
    }

    public static boolean checkExternal(CloseableHttpClient proxy) {
        return ProxyManager.checkConnectionToUrl(proxy, "http://www.google.de");
    }

    public static boolean checkJena(CloseableHttpClient proxy) {
        return ProxyManager.checkConnectionToUrl(proxy, "http://www.uni-jena.de");
    }

    public static boolean checkBioinf(CloseableHttpClient proxy) {
        return ProxyManager.checkConnectionToUrl(proxy, "https://bio.informatik.uni-jena.de");
    }

    public static boolean checkConnectionToUrl(CloseableHttpClient proxy, String url) {
        try {
            CloseableHttpResponse response = proxy.execute((HttpUriRequest)new HttpHead(url));
            int code = response.getStatusLine().getStatusCode();
            LoggerFactory.getLogger(ProxyManager.class).debug("Testing internet connection");
            LoggerFactory.getLogger(ProxyManager.class).debug("Try to connect to: " + url);
            LoggerFactory.getLogger(ProxyManager.class).debug("Response Code: " + code);
            LoggerFactory.getLogger(ProxyManager.class).debug("Response Message: " + response.getStatusLine().getReasonPhrase());
            LoggerFactory.getLogger(ProxyManager.class).debug("Protocol Version: " + response.getStatusLine().getProtocolVersion());
            if (code != 200) {
                LoggerFactory.getLogger(ProxyManager.class).warn("Error Response code: " + response.getStatusLine().getReasonPhrase() + " " + code);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ProxyManager.class).warn("Connection error", (Throwable)e);
            return false;
        }
    }

    public static enum ProxyStrategy {
        SYSTEM,
        SIRIUS,
        NONE;

    }
}

