# Copyright (c) 2002-present, OpenMS Inc. -- EKU Tuebingen, ETH Zurich, and FU Berlin
# SPDX-License-Identifier: Apache-2.0
label: DatabaseSuitability
doc: Computes a suitability score for a database which was used for a peptide identification search. Also reports the quality of LC-MS spectra.
inputs:
  in_id:
    doc: Input idXML file from a peptide identification search with a combined database. PeptideIndexer is needed, FDR is forbidden.
    type: File
  in_spec:
    doc: Input MzML file used for the peptide identification
    type: File
  in_novo:
    doc: Input idXML file containing de novo peptides (unfiltered)
    type: File
  database:
    doc: Input FASTA file of the database in question
    type: File
  novo_database:
    doc: Input deNovo sequences derived from MzML given in 'in_spec' concatenated to one FASTA entry
    type: File
  out:
    doc: Optional tsv output containing database suitability information as well as spectral quality.
    type: string?
  novo_threshold:
    doc: Minimum score a de novo sequence has to have to be defined as 'correct'. The default of 60 is proven to be a good estimate for sequences generated by Novor.
    type: double?
  log:
    doc: Name of log file (created only when specified)
    type: string?
  debug:
    doc: Sets the debug level
    type: long?
  threads:
    doc: Sets the number of threads allowed to be used by the TOPP tool
    type: long?
  no_progress:
    doc: Disables progress logging to command line
    type: boolean?
  force:
    doc: Overrides tool-specific checks
    type: boolean?
  test:
    doc: Enables the test mode (needed for internal use only)
    type: boolean?
  algorithm__no_rerank:
    doc: Use this flag if you want to disable re-ranking. Cases, where a de novo peptide scores just higher than the database peptide, are overlooked and counted as a de novo hit. This might underestimate the database quality.
    type: boolean?
  algorithm__reranking_cutoff_percentile:
    doc: Swap a top-scoring deNovo hit with a lower scoring DB hit if their xcorr score difference is in the given percentile of all score differences between the first two decoy hits of a PSM. The lower the value the lower the decoy cut-off will be. Therefore it will be harder for a lower scoring DB hit to be re-ranked to the top.
    type: double?
  algorithm__FDR:
    doc: Filter peptide hits based on this q-value. (e.g., 0.05 = 5 % FDR)
    type: double?
  algorithm__number_of_subsampled_runs:
    doc: "Controls how many runs should be done for calculating corrected suitability. (0 : number of runs will be estimated automaticly) ATTENTION: For each run a seperate ID-search is performed. This can result in some serious run time."
    type: long?
  algorithm__keep_search_files:
    doc: Set this flag if you wish to keep the files used by and produced by the internal ID search.
    type: boolean?
  algorithm__disable_correction:
    doc: Set this flag to disable the calculation of the corrected suitability.
    type: boolean?
  algorithm__force:
    doc: Set this flag to enforce re-ranking when no cross correlation score is present. For re-ranking the default score found at each peptide hit is used. Use with care!
    type: boolean?
outputs:
  out:
    type: File?
    outputBinding:
      glob: $(inputs.out)
cwlVersion: v1.2
class: CommandLineTool
baseCommand:
  - DatabaseSuitability
requirements:
  InlineJavascriptRequirement: {}
  InitialWorkDirRequirement:
    listing:
      - entryname: cwl_inputs.json
        entry: $(JSON.stringify(inputs))
arguments:
  - -ini
  - cwl_inputs.json
