# Copyright (c) 2002-present, OpenMS Inc. -- EKU Tuebingen, ETH Zurich, and FU Berlin
# SPDX-License-Identifier: Apache-2.0
label: IonMobilityBinning
doc: Splits an mzML file with IonMobility frames into multiple mzML files by binning(merging) spectra by their IM values
inputs:
  in:
    doc: Input file (containing RT, IM, m/z, i.e. IM-frames).
    type: File
  out:
    doc: Path to the output directory to write the binned mzML files to.
    type: string
  bins:
    doc: Number of ion mobility bins to split the input file into
    type: long?
  bin_extension_abs:
    doc: Absolute extension of the bin in IM dimension (causes bins to overlap by 2x this value)
    type: double?
  log:
    doc: Name of log file (created only when specified)
    type: string?
  debug:
    doc: Sets the debug level
    type: long?
  threads:
    doc: Sets the number of threads allowed to be used by the TOPP tool
    type: long?
  no_progress:
    doc: Disables progress logging to command line
    type: boolean?
  force:
    doc: Overrides tool-specific checks
    type: boolean?
  test:
    doc: Enables the test mode (needed for internal use only)
    type: boolean?
  SpectraMerging__mz_binning_width:
    doc: Width of the m/z bins
    type: double?
  SpectraMerging__mz_binning_width_unit:
    doc: Unit of the m/z bin width
    type: string?
outputs:
  out:
    type: File
    outputBinding:
      glob: $(inputs.out)*
cwlVersion: v1.2
class: CommandLineTool
baseCommand:
  - IonMobilityBinning
requirements:
  InlineJavascriptRequirement: {}
  InitialWorkDirRequirement:
    listing:
      - entryname: cwl_inputs.json
        entry: $(JSON.stringify(inputs))
arguments:
  - -ini
  - cwl_inputs.json
