# Copyright (c) 2002-present, OpenMS Inc. -- EKU Tuebingen, ETH Zurich, and FU Berlin
# SPDX-License-Identifier: Apache-2.0
label: SiriusExport
doc: Metabolite identification using single and tandem mass spectrometry
inputs:
  in:
    doc: MzML Input file(s)
    type: File[]
  in_featureinfo:
    doc: FeatureXML input with feature and adduct information
    type: File[]?
  out:
    doc: Internal SIRIUS .ms format after OpenMS preprocessing
    type: string
  out_compoundinfo:
    doc: File (.tsv) with information on processed compounds which are associated with a feature. Required for AssayGeneratorMetaboSirius tool.
    type: string?
  filter_by_num_masstraces:
    doc: Number of mass traces each feature has to have to be included. To use this parameter, setting the feature_only flag is necessary
    type: long?
  precursor_mz_tolerance:
    doc: Tolerance window for precursor selection (Feature selection in regard to the precursor)
    type: double?
  precursor_mz_tolerance_unit:
    doc: Unit of the preprocessing_precursor_mz_tolerance
    type: string?
  precursor_rt_tolerance:
    doc: Tolerance window (left and right) for precursor selection [seconds]
    type: double?
  isotope_pattern_iterations:
    doc: Number of iterations that should be performed to extract the C13 isotope pattern. If no peak is found (C13 distance) the function will abort. Be careful with noisy data - since this can lead to wrong isotope patterns
    type: long?
  feature_only:
    doc: Uses the feature information from in_featureinfo to reduce the search space to MS2 associated with a feature
    type: string?
  no_masstrace_info_isotope_pattern:
    doc: Set to true if the masstrace information from a feature should be discarded and the isotope_pattern_iterations should be used instead
    type: string?
  log:
    doc: Name of log file (created only when specified)
    type: string?
  debug:
    doc: Sets the debug level
    type: long?
  threads:
    doc: Sets the number of threads allowed to be used by the TOPP tool
    type: long?
  no_progress:
    doc: Disables progress logging to command line
    type: boolean?
  force:
    doc: Overrides tool-specific checks
    type: boolean?
  test:
    doc: Enables the test mode (needed for internal use only)
    type: boolean?
outputs:
  out:
    type: File
    outputBinding:
      glob: $(inputs.out)
  out_compoundinfo:
    type: File?
    outputBinding:
      glob: $(inputs.out_compoundinfo)
cwlVersion: v1.2
class: CommandLineTool
baseCommand:
  - SiriusExport
requirements:
  InlineJavascriptRequirement: {}
  InitialWorkDirRequirement:
    listing:
      - entryname: cwl_inputs.json
        entry: $(JSON.stringify(inputs))
arguments:
  - -ini
  - cwl_inputs.json
