/*
 * Decompiled with CFR 0.152.
 */
package de.openms.knime.qchandling;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.NodeLogger;

public abstract class TSVReader {
    private final int m_numberOfColumns;
    private final boolean m_ignoreAdditionalContent;
    private final boolean m_ignoreMissingColumns;
    private static final NodeLogger LOGGER = NodeLogger.getLogger(TSVReader.class);
    private static final String SEPARATOR = "\t";

    public TSVReader(int numberOfColumns, boolean ignoreAdditionalContent, boolean ignoreMissingColumns) {
        this.m_numberOfColumns = numberOfColumns;
        this.m_ignoreAdditionalContent = ignoreAdditionalContent;
        this.m_ignoreMissingColumns = ignoreMissingColumns;
    }

    public TSVReader(int numberOfColumns, boolean ignoreAdditionalContent) {
        this(numberOfColumns, ignoreAdditionalContent, false);
    }

    public TSVReader(int numberOfColumns) {
        this(numberOfColumns, false, false);
    }

    protected abstract String[] getHeader();

    private void validateHeader(String headerLine) throws InvalidHeaderException {
        if (headerLine == null) {
            throw new InvalidHeaderException("Could not extract a header from the given file.");
        }
        String[] header = headerLine.trim().split(SEPARATOR, -1);
        if (header.length > this.m_numberOfColumns && !this.m_ignoreAdditionalContent) {
            throw new InvalidHeaderException(this.m_numberOfColumns, header.length);
        }
        if (header.length < this.m_numberOfColumns && !this.m_ignoreMissingColumns) {
            throw new InvalidHeaderException(this.m_numberOfColumns, header.length);
        }
        int i = 0;
        while (i < this.m_numberOfColumns && i < header.length) {
            if (!header[i].equals(this.getHeader()[i])) {
                throw new InvalidHeaderException(this.getHeader()[i], header[i]);
            }
            ++i;
        }
    }

    protected abstract DataCell[] parseLine(String[] var1);

    public void run(File tsvFile, BufferedDataContainer container, ExecutionContext exec) throws IOException, InvalidLineException, CanceledExecutionException, InvalidHeaderException {
        BufferedReader brReader = null;
        try {
            try {
                String line;
                brReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tsvFile), "UTF-8"));
                String header = brReader.readLine();
                this.validateHeader(header);
                int rowIdx = 1;
                while ((line = brReader.readLine()) != null) {
                    if ("".equals(line.trim())) continue;
                    String[] tokens = line.trim().split(SEPARATOR, -1);
                    try {
                        DataCell[] cells = this.parseLine(tokens);
                        RowKey key = new RowKey("Row " + rowIdx);
                        DefaultRow row = new DefaultRow(key, cells);
                        container.addRowToTable((DataRow)row);
                    }
                    catch (Exception ex) {
                        throw new InvalidLineException(rowIdx, line, ex);
                    }
                    exec.checkCanceled();
                    ++rowIdx;
                }
            }
            catch (IOException ex) {
                LOGGER.error((Object)ex.getMessage());
                throw ex;
            }
        }
        finally {
            if (brReader != null) {
                brReader.close();
            }
        }
    }

    public static class InvalidHeaderException
    extends Exception {
        private static final long serialVersionUID = 3447134484787762192L;

        public InvalidHeaderException(int expected, int actual) {
            super("Invalid file header. Expected " + expected + " columns but got " + actual + ".");
        }

        public InvalidHeaderException(String expected, String actual) {
            super("Invalid header element: Expected " + expected + " but got " + actual + ".");
        }

        public InvalidHeaderException(String message) {
            super(message);
        }
    }

    public static class InvalidLineException
    extends Exception {
        private static final long serialVersionUID = 8638283665268501023L;

        public InvalidLineException(int lineNumber, String offendingLine) {
            super("Invalid file. Offending line: nr=" + lineNumber + "; " + offendingLine);
        }

        public InvalidLineException(int lineNumber, String offendingLine, Throwable cause) {
            super("Invalid file. Offending line: nr=" + lineNumber + "; " + offendingLine, cause);
        }
    }
}

