/*
 * Decompiled with CFR 0.152.
 */
package de.openms.knime.qchandling.qcfeaturereader;

import de.openms.knime.qchandling.TSVReader;
import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.uri.IURIPortObject;
import org.knime.core.data.uri.URIContent;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

public class QCFeatureReaderNodeModel
extends NodeModel {
    private static final int NUMBER_OF_COLUMNS = 7;

    private static PortType[] getIncomingPorts() {
        return new PortType[]{IURIPortObject.TYPE};
    }

    private static PortType[] getOutgoingPorts() {
        return new PortType[]{new PortType(BufferedDataTable.class)};
    }

    protected QCFeatureReaderNodeModel() {
        super(QCFeatureReaderNodeModel.getIncomingPorts(), QCFeatureReaderNodeModel.getOutgoingPorts());
    }

    private DataTableSpec createColumnSpec() {
        DataColumnSpec[] allColSpecs = new DataColumnSpec[]{new DataColumnSpecCreator("MZ", DoubleCell.TYPE).createSpec(), new DataColumnSpecCreator("RT", DoubleCell.TYPE).createSpec(), new DataColumnSpecCreator("Intensity", DoubleCell.TYPE).createSpec(), new DataColumnSpecCreator("Charge", IntCell.TYPE).createSpec(), new DataColumnSpecCreator("Quality", DoubleCell.TYPE).createSpec(), new DataColumnSpecCreator("FWHM", DoubleCell.TYPE).createSpec(), new DataColumnSpecCreator("IDs", IntCell.TYPE).createSpec()};
        return new DataTableSpec(allColSpecs);
    }

    protected BufferedDataTable[] execute(PortObject[] inData, ExecutionContext exec) throws IOException, TSVReader.InvalidLineException, CanceledExecutionException, TSVReader.InvalidHeaderException {
        TSVReader featureTSVReader = new TSVReader(7, false, true){

            @Override
            protected DataCell[] parseLine(String[] tokens) {
                DataCell[] cells = new DataCell[]{new DoubleCell(Double.parseDouble(tokens[0])), new DoubleCell(Double.parseDouble(tokens[1])), new DoubleCell(Double.parseDouble(tokens[2])), new IntCell(Integer.parseInt(tokens[3])), tokens.length > 4 ? new DoubleCell(Double.parseDouble(tokens[4])) : new DoubleCell(-1.0), tokens.length > 5 ? new DoubleCell(Double.parseDouble(tokens[5])) : new DoubleCell(-1.0), tokens.length > 6 ? new IntCell(Integer.parseInt(tokens[6])) : new IntCell(-1)};
                return cells;
            }

            @Override
            protected String[] getHeader() {
                return new String[]{"MZ", "RT", "Intensity", "Charge", "Quality", "FWHM", "IDs"};
            }
        };
        BufferedDataContainer container = exec.createDataContainer(this.createColumnSpec());
        featureTSVReader.run(new File(((URIContent)((IURIPortObject)inData[0]).getURIContents().get(0)).getURI()), container, exec);
        container.close();
        return new BufferedDataTable[]{container.getTable()};
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new DataTableSpec[]{this.createColumnSpec()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

