/*
 * Decompiled with CFR 0.152.
 */
package de.openms.knime.startupcheck;

import de.openms.knime.startupcheck.Activator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.knime.core.node.NodeLogger;
import org.knime.workbench.ui.startup.StartupMessage;
import org.knime.workbench.ui.startup.StartupMessageProvider;

public class OpenMSStartupMessageProvider
implements StartupMessageProvider {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(OpenMSStartupMessageProvider.class);
    private static final String OPENMS_REQUIREMENTS_URI = "https://abibuilder.cs.uni-tuebingen.de/archive/openms/OpenMSInstaller/PrerequisitesInstaller/OpenMS-3.0-prerequisites-installer.exe";

    public List<StartupMessage> getMessages() {
        this.isWindows();
        return new ArrayList<StartupMessage>();
    }

    private List<StartupMessage> getWarning() {
        String longMessage = String.format("Some of the requirements for the OpenMS KNIME Nodes are missing on your system. Please download the requirements installer from <a href=\"%s\">here</a>.", OPENMS_REQUIREMENTS_URI);
        String shortMessage = "Some of the OpenMS KNIME Nodes requirements might be missing. Double click for details.";
        StartupMessage message = new StartupMessage(longMessage, "Some of the OpenMS KNIME Nodes requirements might be missing. Double click for details.", 2, Activator.getInstance().getBundle());
        ArrayList<StartupMessage> messages = new ArrayList<StartupMessage>();
        messages.add(message);
        return messages;
    }

    private boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private boolean powershellCMD(String command) throws IOException {
        String line;
        String cmd = "powershell.exe " + command;
        Process powerShellProcess = Runtime.getRuntime().exec(cmd);
        powerShellProcess.getOutputStream().close();
        LOGGER.debug((Object)"Standard Output:");
        BufferedReader stdout = new BufferedReader(new InputStreamReader(powerShellProcess.getInputStream()));
        boolean result = false;
        while ((line = stdout.readLine()) != null) {
            LOGGER.debug((Object)line);
            result = true;
        }
        stdout.close();
        LOGGER.debug((Object)"Standard Error:");
        BufferedReader stderr = new BufferedReader(new InputStreamReader(powerShellProcess.getErrorStream()));
        while ((line = stderr.readLine()) != null) {
            LOGGER.debug((Object)line);
        }
        stderr.close();
        return result;
    }
}

