/*
 * Decompiled with CFR 0.152.
 */
package de.openms.knime.startupcheck.registryaccess;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class WinRegistryQuery {
    public static String extractFromStdout(String key, String valueName, String stdOut) {
        String[] lines = stdOut.split(System.getProperty("line.separator"));
        int i = 0;
        while (i < lines.length) {
            if (key.equals(lines[i].trim()) && lines[++i].trim().startsWith(valueName)) {
                return lines[i].trim().split("\\s+")[2];
            }
            ++i;
        }
        return "";
    }

    public static String getValue(String key, String type, String valueName) {
        String stdOut;
        block6: {
            String stdErr;
            block5: {
                String keyAsCmdParameter = "\"" + key + "\"";
                ProcessBuilder processBuilder = new ProcessBuilder("reg", "query", keyAsCmdParameter, "/v", valueName, "/t", type);
                Process process = processBuilder.start();
                int returnCode = process.waitFor();
                stdOut = WinRegistryQuery.extractStdMessages(process.getInputStream());
                stdErr = WinRegistryQuery.extractStdMessages(process.getErrorStream());
                if (returnCode == 0) break block5;
                return "";
            }
            if (stdErr.trim().length() <= 0) break block6;
            return "";
        }
        try {
            return WinRegistryQuery.extractFromStdout(key, valueName, stdOut);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean checkValue(String key, String type, String valueName, String expectedValue) {
        return WinRegistryQuery.getValue(key, type, valueName).equals(expectedValue);
    }

    public static boolean checkValueGreater(String key, String type, String valueName, int expectedValue, boolean checkGreaterEq) {
        Integer actual = Integer.decode(WinRegistryQuery.getValue(key, type, valueName));
        if (checkGreaterEq) {
            return actual >= expectedValue;
        }
        return actual < expectedValue;
    }

    private static String extractStdMessages(InputStream stream) throws IOException {
        InputStreamReader isr = new InputStreamReader(stream);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        StringBuffer out = new StringBuffer();
        while ((line = br.readLine()) != null) {
            out.append(String.valueOf(line) + System.getProperty("line.separator"));
        }
        return out.toString();
    }
}

