/*
 * Decompiled with CFR 0.152.
 */
package de.openms.knime.mztab;

import de.openms.knime.InvalidInputException;
import de.openms.knime.mztab.exceptions.InvalidMTDLineException;
import de.openms.knime.mztab.exceptions.InvalidMzTabFormatException;
import de.openms.knime.mztab.exceptions.InvalidMzTabLineException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.MissingCell;
import org.knime.core.data.RowKey;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.uri.IURIPortObject;
import org.knime.core.data.uri.URIContent;
import org.knime.core.data.uri.URIPortObjectSpec;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

public class MzTabReaderNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(MzTabReaderNodeModel.class);
    private int metaDataRowIdx = 1;
    private int proteinRowIdx = 1;
    private int peptideRowIdx = 1;
    private int psmRowIdx = 1;
    private int smallMolRowIdx = 1;
    Pattern regSearchEngineScore = Pattern.compile("^(best_)?search_engine_score.*$");
    Pattern regAbundance = Pattern.compile("^(?!opt_).+.*_abundance.*$");
    Pattern regNumberOf = Pattern.compile("^num_.*$");

    private DataTableSpec createMetaDataSectionSpec() {
        DataColumnSpec[] colSpecs = new DataColumnSpec[]{new DataColumnSpecCreator("fieldname", StringCell.TYPE).createSpec(), new DataColumnSpecCreator("value", StringCell.TYPE).createSpec()};
        return new DataTableSpec(colSpecs);
    }

    protected MzTabReaderNodeModel() {
        super(new PortType[]{IURIPortObject.TYPE}, new PortType[]{BufferedDataTable.TYPE, BufferedDataTable.TYPE, BufferedDataTable.TYPE, BufferedDataTable.TYPE, BufferedDataTable.TYPE});
    }

    protected BufferedDataTable[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        BufferedDataTable smallMolTable;
        BufferedDataTable psmDataTable;
        BufferedDataTable peptideDataTable;
        BufferedDataTable proteinDataTable;
        BufferedDataTable metaDataTable;
        block33: {
            this.metaDataRowIdx = 1;
            this.proteinRowIdx = 1;
            this.peptideRowIdx = 1;
            this.psmRowIdx = 1;
            this.smallMolRowIdx = 1;
            IURIPortObject obj = (IURIPortObject)inObjects[0];
            List uris = obj.getURIContents();
            if (uris.size() == 0) {
                throw new InvalidInputException("No URI was supplied in URIPortObject at input port 0");
            }
            if (uris.size() != 1) {
                throw new InvalidInputException(String.format("We can only demangle a single file but got %d.", uris.size()));
            }
            URI relURI = ((URIContent)uris.get(0)).getURI();
            File cXMLFile = new File(relURI);
            BufferedReader brReader = null;
            BufferedDataContainer metaDataContainer = null;
            metaDataTable = null;
            BufferedDataContainer proteinDataContainer = null;
            proteinDataTable = null;
            BufferedDataContainer peptideDataContainer = null;
            peptideDataTable = null;
            BufferedDataContainer psmDataContainer = null;
            psmDataTable = null;
            BufferedDataContainer smallMolContainer = null;
            smallMolTable = null;
            try {
                try {
                    brReader = new BufferedReader(new InputStreamReader(new FileInputStream(cXMLFile)));
                    String line = brReader.readLine();
                    metaDataContainer = exec.createDataContainer(this.createMetaDataSectionSpec());
                    do {
                        if (line.trim().length() == 0) continue;
                        if (line.trim().length() < 3) {
                            throw new InvalidMzTabFormatException("Found non-empty line without an identifier.");
                        }
                        String identifier = line.trim().substring(0, 3);
                        if ("MTD".equals(identifier)) {
                            this.parseMTDLine(metaDataContainer, line);
                        } else if ("PRH".equals(identifier)) {
                            DataTableSpec proteinSpec = this.parseHeaderLine(line, "PRT");
                            proteinDataContainer = exec.createDataContainer(proteinSpec);
                        } else if ("PRT".equals(identifier)) {
                            this.parsePRTLine(proteinDataContainer, line);
                        } else if ("PEH".equals(identifier)) {
                            DataTableSpec pepSpec = this.parseHeaderLine(line, "PEP");
                            peptideDataContainer = exec.createDataContainer(pepSpec);
                        } else if ("PEP".equals(identifier)) {
                            this.parsePEPLine(peptideDataContainer, line);
                        } else if ("PSH".equals(identifier)) {
                            DataTableSpec psmSpec = this.parseHeaderLine(line, "PSM");
                            psmDataContainer = exec.createDataContainer(psmSpec);
                        } else if ("PSM".equals(identifier)) {
                            this.parsePSMLine(psmDataContainer, line);
                        } else if ("SMH".equals(identifier)) {
                            DataTableSpec smSpec = this.parseHeaderLine(line, "SML");
                            smallMolContainer = exec.createDataContainer(smSpec);
                        } else if ("SML".equals(identifier)) {
                            this.parseSMLLine(smallMolContainer, line);
                        }
                        exec.checkCanceled();
                    } while ((line = brReader.readLine()) != null);
                    if (proteinDataContainer == null) {
                        proteinDataContainer = exec.createDataContainer(this.createEmptySpec());
                    }
                    if (peptideDataContainer == null) {
                        peptideDataContainer = exec.createDataContainer(this.createEmptySpec());
                    }
                    if (psmDataContainer == null) {
                        psmDataContainer = exec.createDataContainer(this.createEmptySpec());
                    }
                    if (smallMolContainer == null) {
                        smallMolContainer = exec.createDataContainer(this.createEmptySpec());
                    }
                    metaDataContainer.close();
                    metaDataTable = metaDataContainer.getTable();
                    proteinDataContainer.close();
                    proteinDataTable = proteinDataContainer.getTable();
                    peptideDataContainer.close();
                    peptideDataTable = peptideDataContainer.getTable();
                    psmDataContainer.close();
                    psmDataTable = psmDataContainer.getTable();
                    smallMolContainer.close();
                    smallMolTable = smallMolContainer.getTable();
                }
                catch (CanceledExecutionException e) {
                    logger.info((Object)"Canceled execution!");
                    if (brReader != null) {
                        brReader.close();
                    }
                    break block33;
                }
            }
            catch (Throwable throwable) {
                if (brReader != null) {
                    brReader.close();
                }
                throw throwable;
            }
            if (brReader != null) {
                brReader.close();
            }
        }
        return new BufferedDataTable[]{metaDataTable, proteinDataTable, peptideDataTable, psmDataTable, smallMolTable};
    }

    private void parseMTDLine(BufferedDataContainer metaDataContainer, String line) throws InvalidMTDLineException {
        String[] line_entries = line.split("\t");
        if (line_entries.length != 3) {
            throw new InvalidMTDLineException(line);
        }
        DataCell[] cells = this.parseGenericLine(line_entries, metaDataContainer);
        RowKey key = new RowKey("Row " + this.metaDataRowIdx++);
        DefaultRow row = new DefaultRow(key, cells);
        metaDataContainer.addRowToTable((DataRow)row);
    }

    private void parsePRTLine(BufferedDataContainer proteinDataContainer, String line) throws InvalidMzTabLineException, InvalidMzTabFormatException {
        String[] line_entries = line.split("\t");
        if (proteinDataContainer == null) {
            throw new InvalidMzTabFormatException("Found PRT before PRH");
        }
        if (line_entries.length != proteinDataContainer.getTableSpec().getNumColumns() + 1) {
            throw new InvalidMzTabLineException(line);
        }
        DataCell[] cells = this.parseGenericLine(line_entries, proteinDataContainer);
        RowKey key = new RowKey("Row " + this.proteinRowIdx++);
        DefaultRow row = new DefaultRow(key, cells);
        proteinDataContainer.addRowToTable((DataRow)row);
    }

    private void parsePEPLine(BufferedDataContainer peptideDataContainer, String line) throws InvalidMzTabLineException, InvalidMzTabFormatException {
        String[] line_entries = line.split("\t");
        if (peptideDataContainer == null) {
            throw new InvalidMzTabFormatException("Found PEP before PEH");
        }
        if (line_entries.length != peptideDataContainer.getTableSpec().getNumColumns() + 1) {
            throw new InvalidMzTabLineException(line);
        }
        DataCell[] cells = this.parseGenericLine(line_entries, peptideDataContainer);
        RowKey key = new RowKey("Row " + this.peptideRowIdx++);
        DefaultRow row = new DefaultRow(key, cells);
        peptideDataContainer.addRowToTable((DataRow)row);
    }

    private void parsePSMLine(BufferedDataContainer psmDataContainer, String line) throws InvalidMzTabLineException, InvalidMzTabFormatException {
        String[] line_entries = line.split("\t");
        if (psmDataContainer == null) {
            throw new InvalidMzTabFormatException("Found PSM before PSH");
        }
        if (line_entries.length != psmDataContainer.getTableSpec().getNumColumns() + 1) {
            throw new InvalidMzTabLineException(line);
        }
        DataCell[] cells = this.parseGenericLine(line_entries, psmDataContainer);
        RowKey key = new RowKey("Row " + this.psmRowIdx++);
        DefaultRow row = new DefaultRow(key, cells);
        psmDataContainer.addRowToTable((DataRow)row);
    }

    private void parseSMLLine(BufferedDataContainer smallMolDataContainer, String line) throws InvalidMzTabLineException, InvalidMzTabFormatException {
        String[] line_entries = line.split("\t");
        if (smallMolDataContainer == null) {
            throw new InvalidMzTabFormatException("Found SML before SMH");
        }
        if (line_entries.length != smallMolDataContainer.getTableSpec().getNumColumns() + 1) {
            throw new InvalidMzTabLineException(line);
        }
        DataCell[] cells = this.parseGenericLine(line_entries, smallMolDataContainer);
        RowKey key = new RowKey("Row " + this.smallMolRowIdx++);
        DefaultRow row = new DefaultRow(key, cells);
        smallMolDataContainer.addRowToTable((DataRow)row);
    }

    private DataCell[] parseGenericLine(String[] line_entries, BufferedDataContainer container) {
        DataCell[] cells = new DataCell[container.getTableSpec().getNumColumns()];
        int i = 0;
        while (i < container.getTableSpec().getNumColumns()) {
            int n;
            ArrayList<Object> lc;
            DataColumnSpec spec = container.getTableSpec().getColumnSpec(i);
            if (spec.getType() == IntCell.TYPE) {
                cells[i] = line_entries[i + 1] == null || "null".equals(line_entries[i + 1]) || "-".equals(line_entries[i + 1]) ? new MissingCell(line_entries[i + 1]) : new IntCell(Integer.parseInt(line_entries[i + 1]));
            } else if (spec.getType() == DoubleCell.TYPE) {
                cells[i] = line_entries[i + 1] == null || "INF".equals(line_entries[i + 1]) || "NaN".equals(line_entries[i + 1]) || "null".equals(line_entries[i + 1]) || "-".equals(line_entries[i + 1]) ? new MissingCell(line_entries[i + 1]) : new DoubleCell(Double.parseDouble(line_entries[i + 1]));
            } else if (spec.getType() == ListCell.getCollectionType((DataType)DoubleCell.TYPE)) {
                if (line_entries[i + 1] == null || "null".equals(line_entries[i + 1]) || "-".equals(line_entries[i + 1])) {
                    cells[i] = new MissingCell(line_entries[i + 1]);
                } else {
                    String[] sl;
                    lc = new ArrayList<Object>();
                    String[] stringArray = sl = line_entries[i + 1].split("\\|");
                    n = sl.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String dstr = stringArray[n2];
                        double d = Double.parseDouble(dstr);
                        lc.add(new DoubleCell(d));
                        ++n2;
                    }
                    ListCell outputCell = CollectionCellFactory.createListCell(lc);
                    cells[i] = outputCell;
                }
            } else if (spec.getType() == ListCell.getCollectionType((DataType)IntCell.TYPE)) {
                if (line_entries[i + 1] == null || "null".equals(line_entries[i + 1]) || "-".equals(line_entries[i + 1])) {
                    cells[i] = new MissingCell(line_entries[i + 1]);
                } else {
                    lc = new ArrayList();
                    String[] stringArray = line_entries[i + 1].split(",");
                    int n3 = stringArray.length;
                    int outputCell = 0;
                    while (outputCell < n3) {
                        String dstr = stringArray[outputCell];
                        int j = Integer.parseInt(dstr);
                        lc.add(new IntCell(j));
                        ++outputCell;
                    }
                    ListCell outputCell2 = CollectionCellFactory.createListCell(lc);
                    cells[i] = outputCell2;
                }
            } else if (spec.getType() == ListCell.getCollectionType((DataType)StringCell.TYPE)) {
                String col = spec.getName().toLowerCase();
                if (line_entries[i + 1] == null || "null".equals(line_entries[i + 1]) || "-".equals(line_entries[i + 1])) {
                    cells[i] = new MissingCell(line_entries[i + 1]);
                } else {
                    ArrayList<StringCell> lc2 = new ArrayList<StringCell>();
                    String[] sl = col.equals("modifications") ? line_entries[i + 1].split(",(?![^\\[\\]]*+\\])") : (col.equals("accession") || col.equals("ambiguity_members") || col.equals("pre") || col.equals("post") ? line_entries[i + 1].split(",") : line_entries[i + 1].split("\\|"));
                    String[] stringArray = sl;
                    int n4 = sl.length;
                    n = 0;
                    while (n < n4) {
                        String str = stringArray[n];
                        lc2.add(new StringCell(str));
                        ++n;
                    }
                    ListCell outputCell = CollectionCellFactory.createListCell(lc2);
                    cells[i] = outputCell;
                }
            } else if (spec.getType() == BooleanCell.TYPE) {
                if (line_entries[i + 1] == null || "null".equals(line_entries[i + 1]) || "-".equals(line_entries[i + 1])) {
                    cells[i] = new MissingCell(line_entries[i + 1]);
                } else {
                    BooleanCell cell = BooleanCell.FALSE;
                    if (this.convertToBoolean(line_entries[i + 1])) {
                        cell = BooleanCell.TRUE;
                    }
                    cells[i] = cell;
                }
            } else {
                cells[i] = new StringCell(line_entries[i + 1]);
            }
            ++i;
        }
        return cells;
    }

    private boolean convertToBoolean(String value) {
        boolean returnValue = false;
        if ("1".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value)) {
            returnValue = true;
        }
        return returnValue;
    }

    private DataTableSpec parseHeaderLine(String line, String section) {
        String[] line_entries = line.split("\t");
        DataColumnSpec[] colSpecs = new DataColumnSpec[line_entries.length - 1];
        int i = 1;
        while (i < line_entries.length) {
            DataType type = this.getDataType(line_entries[i], section);
            colSpecs[i - 1] = new DataColumnSpecCreator(line_entries[i], type).createSpec();
            ++i;
        }
        return new DataTableSpec(colSpecs);
    }

    private DataTableSpec createEmptySpec() {
        return new DataTableSpec(new DataColumnSpec[0]);
    }

    private DataType getDataType(String fieldName, String section) {
        String trimmed = fieldName.trim();
        if (this.isDouble(trimmed)) {
            return DoubleCell.TYPE;
        }
        if (this.isInt(trimmed)) {
            return IntCell.TYPE;
        }
        if (this.isBool(trimmed)) {
            return BooleanCell.TYPE;
        }
        if (this.isDoubleList(trimmed)) {
            return ListCell.getCollectionType((DataType)DoubleCell.TYPE);
        }
        if (this.isIntList(trimmed)) {
            return ListCell.getCollectionType((DataType)IntCell.TYPE);
        }
        if (this.isStringList(trimmed, section)) {
            return ListCell.getCollectionType((DataType)StringCell.TYPE);
        }
        return StringCell.TYPE;
    }

    private boolean isDouble(String fieldName) {
        return "exp_mass_to_charge".equals(fieldName) || "calc_mass_to_charge".equals(fieldName) || "mass_to_charge".equals(fieldName) || "protein_coverage".equals(fieldName) || this.regAbundance.matcher(fieldName).matches() || this.regSearchEngineScore.matcher(fieldName).matches();
    }

    private boolean isDoubleList(String fieldName) {
        return "retention_time".equals(fieldName) || "retention_time_window".equals(fieldName);
    }

    private boolean isIntList(String fieldName) {
        return "start".equals(fieldName) || "end".equals(fieldName);
    }

    private boolean isStringList(String fieldName, String section) {
        return "accession".equals(fieldName) && section.equals("PSM") || "pre".equals(fieldName) || "post".equals(fieldName) || "modifications".equals(fieldName) || "spectra_ref".equals(fieldName) || "go_terms".equals(fieldName) || "search_engine".equals(fieldName) || "ambiguity_members".equals(fieldName) || "identifier".equals(fieldName) || "smiles".equals(fieldName) || "inchi_key".equals(fieldName);
    }

    private boolean isInt(String fieldName) {
        return "charge".equals(fieldName) || "taxid".equals(fieldName) || "reliability".equals(fieldName) || this.regNumberOf.matcher(fieldName).matches();
    }

    private boolean isBool(String fieldName) {
        return "unique".equals(fieldName);
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        URIPortObjectSpec spec = (URIPortObjectSpec)inSpecs[0];
        for (String ext : spec.getFileExtensions()) {
            if (ext.toLowerCase().equals("mztab") || ext.toLowerCase().equals("tsv")) continue;
            throw new InvalidSettingsException("Only mzTab files supported (with extension mzTab or tsv)");
        }
        DataTableSpec[] dataTableSpecArray = new DataTableSpec[5];
        dataTableSpecArray[0] = this.createMetaDataSectionSpec();
        return dataTableSpecArray;
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

