/*
 * Decompiled with CFR 0.152.
 */
package de.openms.knime.qchandling.qcticreader;

import de.openms.knime.qchandling.TSVReader;
import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.uri.IURIPortObject;
import org.knime.core.data.uri.URIContent;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

public class QCTICReaderNodeModel
extends NodeModel {
    private static PortType[] getIncomingPorts() {
        return new PortType[]{IURIPortObject.TYPE};
    }

    private static PortType[] getOutgoingPorts() {
        return new PortType[]{new PortType(BufferedDataTable.class)};
    }

    protected QCTICReaderNodeModel() {
        super(QCTICReaderNodeModel.getIncomingPorts(), QCTICReaderNodeModel.getOutgoingPorts());
    }

    protected BufferedDataTable[] execute(PortObject[] inData, ExecutionContext exec) throws IOException, TSVReader.InvalidLineException, CanceledExecutionException, TSVReader.InvalidHeaderException {
        TSVReader ticTSVReader = new TSVReader(2){

            @Override
            protected DataCell[] parseLine(String[] tokens) {
                DataCell[] cells = new DataCell[]{new DoubleCell(Double.parseDouble(tokens[0])), new DoubleCell(Double.parseDouble(tokens[1]))};
                return cells;
            }

            @Override
            protected String[] getHeader() {
                return new String[]{"MS:1000894_[sec]", "MS:1000285"};
            }
        };
        BufferedDataContainer container = exec.createDataContainer(this.createColumnSpec());
        ticTSVReader.run(new File(((URIContent)((IURIPortObject)inData[0]).getURIContents().get(0)).getURI()), container, exec);
        container.close();
        return new BufferedDataTable[]{container.getTable()};
    }

    private DataTableSpec createColumnSpec() {
        DataColumnSpec[] allColSpecs = new DataColumnSpec[]{new DataColumnSpecCreator("RT", DoubleCell.TYPE).createSpec(), new DataColumnSpecCreator("TIC", DoubleCell.TYPE).createSpec()};
        return new DataTableSpec(allColSpecs);
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new DataTableSpec[]{this.createColumnSpec()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

