/*
 * Decompiled with CFR 0.152.
 */
package de.openms.thirdparty.knime.startupcheck;

import de.openms.thirdparty.knime.startupcheck.Activator;
import de.openms.thirdparty.knime.startupcheck.registryaccess.WinRegistryQuery;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.knime.core.node.NodeLogger;
import org.knime.workbench.ui.startup.StartupMessage;
import org.knime.workbench.ui.startup.StartupMessageProvider;

public class OpenMSThirdpartyStartupMessageProvider
implements StartupMessageProvider {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(OpenMSThirdpartyStartupMessageProvider.class);
    private static final String OPENMS_REQUIREMENTS_URI = "https://abibuilder.cs.uni-tuebingen.de/archive/openms/OpenMSInstaller/PrerequisitesInstaller/OpenMS-3.0-prerequisites-installer.exe";
    private static final String REG_DWORD_1 = "0x1";
    private static final String NET4_FULL_KEY = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v4\\Full";
    private static final String NET4_CLIENT_KEY = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v4\\Client";

    public List<StartupMessage> getMessages() {
        try {
            if (this.isWindows() && this.is64BitSystem()) {
                boolean pwizok = true;
                boolean dotNet4ValueClientExists = WinRegistryQuery.checkValue(NET4_CLIENT_KEY, "REG_DWORD", "Install", REG_DWORD_1);
                LOGGER.debug((Object)(".NET4 Client Value exists: " + dotNet4ValueClientExists));
                boolean dotNet4ValueFullExists = WinRegistryQuery.checkValue(NET4_FULL_KEY, "REG_DWORD", "Install", REG_DWORD_1);
                LOGGER.debug((Object)(".NET4 Full Value exists: " + dotNet4ValueFullExists));
                boolean bl = pwizok = dotNet4ValueClientExists && dotNet4ValueFullExists;
                if (!pwizok) {
                    return this.getPwizWarning();
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn((Object)"Error when querying windows registry.", (Throwable)e);
        }
        return new ArrayList<StartupMessage>();
    }

    private List<StartupMessage> getPwizWarning() {
        String longMessage = String.format("When using the OpenMS node 'FileConverter' with for conversion from vendor formats (e.g., Thermo RAW) it calls the packaged ProteoWizard. But not all dependencies for ProteoWizard were found. If you are not intending to use this functionality, please ignore this message. Otherwise, try our prerequisites installer <a href=\"%s\">here</a> first (and restart KNIME). If it does not help, consider installing ALL redistributables from <a href=\"https://support.microsoft.com/en-us/help/2977003/the-latest-supported-visual-c-downloads\">here</a>. Please note that our check might not always be uptodate. Try executing 'FileConverter' on a vendor file despite this warning first, before reporting any issues.", OPENMS_REQUIREMENTS_URI);
        String shortMessage = "Some of the requirements for the FileConverter node from OpenMS might be missing. Double click for details.";
        StartupMessage message = new StartupMessage(longMessage, "Some of the requirements for the FileConverter node from OpenMS might be missing. Double click for details.", 2, Activator.getInstance().getBundle());
        ArrayList<StartupMessage> messages = new ArrayList<StartupMessage>();
        messages.add(message);
        return messages;
    }

    private boolean is64BitSystem() {
        return "64".equals(System.getProperty("sun.arch.data.model"));
    }

    private boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private boolean powershellCMD(String command) throws IOException {
        String line;
        String cmd = "powershell.exe " + command;
        Process powerShellProcess = Runtime.getRuntime().exec(cmd);
        powerShellProcess.getOutputStream().close();
        LOGGER.debug((Object)"Standard Output:");
        BufferedReader stdout = new BufferedReader(new InputStreamReader(powerShellProcess.getInputStream()));
        boolean result = false;
        while ((line = stdout.readLine()) != null) {
            LOGGER.debug((Object)line);
            result = true;
        }
        stdout.close();
        LOGGER.debug((Object)"Standard Error:");
        BufferedReader stderr = new BufferedReader(new InputStreamReader(powerShellProcess.getErrorStream()));
        while ((line = stderr.readLine()) != null) {
            LOGGER.debug((Object)line);
        }
        stderr.close();
        return result;
    }
}

